/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;

public abstract class AbstractDataManager<T, U>
extends ReloadListener<Map<ResourceLocation, U>>
implements IDataManager<T> {
    protected static final Gson GSON = new GsonBuilder().create();
    private final Class<T> contentType;
    private final Function<ResourceLocation, T> defaultValueFactory;
    private BiMap<ResourceLocation, T> data = ImmutableBiMap.of();
    protected final String folder;
    protected final BiConsumer<T, ResourceLocation> idSetter;
    protected ResourceLocation id;

    public AbstractDataManager(Class<? extends T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter) {
        this.contentType = contentType;
        this.defaultValueFactory = defaultValueFactory;
        this.idSetter = idSetter;
        this.folder = folder;
    }

    @Override
    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    @Override
    public void setData(Map<ResourceLocation, T> map) {
        map.forEach((loc, value) -> this.idSetter.accept(value, (ResourceLocation)loc));
        this.data = ImmutableBiMap.copyOf(map);
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.data.size(), (Object)this.id);
    }

    @Override
    public Class<T> getContentType() {
        return this.contentType;
    }

    @Override
    public ResourceLocation getId(T value) {
        return (ResourceLocation)this.data.inverse().getOrDefault(value, (Object)DataPackAnvilApi.ID_NONE);
    }

    @Override
    public T get(ResourceLocation id) {
        Object value = this.data.get((Object)id);
        if (value != null) {
            return (T)value;
        }
        return this.defaultValueFactory.apply(id);
    }

    @Override
    public String getFolder() {
        return this.folder;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }
}

