/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.data.network.message.MessageHandler;

public class MessageHelper {
    public static final PacketDistributor<Void> ALL_REMOTE = new PacketDistributor(MessageHelper::playerListAllRemote, NetworkDirection.PLAY_TO_CLIENT);

    public static <T> void sendToPlayer(ServerPlayerEntity serverPlayer, T message) {
        MessageHandler.CHANNEL.sendTo(message, serverPlayer.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <T> void sendToRemotePlayer(ServerPlayerEntity serverPlayer, T message) {
        if (DataPackAnvil.PROXY.isRemotePlayer((PlayerEntity)serverPlayer)) {
            MessageHelper.sendToPlayer(serverPlayer, message);
        }
    }

    public static <T> void sendToAllPlayers(T message) {
        MessageHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <T> void sendToAllRemotePlayers(T message) {
        MessageHandler.CHANNEL.send(ALL_REMOTE.noArg(), message);
    }

    private static Consumer<IPacket<?>> playerListAllRemote(PacketDistributor<Void> distributor, Supplier<Void> voidSupplier) {
        return p -> ((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_184103_al().func_181057_v().stream().filter(DataPackAnvil.PROXY::isRemotePlayer).forEach(player -> player.field_71135_a.func_147359_a(p));
    }
}

