/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import sirttas.elementalcraft.api.element.ElementType;

public interface IElementStorage {
    public int getElementAmount(ElementType var1);

    public int getElementCapacity(ElementType var1);

    public int insertElement(int var1, ElementType var2, boolean var3);

    public int extractElement(int var1, ElementType var2, boolean var3);

    default public int transferTo(IElementStorage other, ElementType type, int count) {
        return this.transferTo(other, type, count, 1.0f);
    }

    default public int transferTo(IElementStorage other, ElementType type, float count, float multiplier) {
        int amount = Math.round((float)this.extractElement(Math.round(count / multiplier), type, true) * multiplier);
        amount -= other.insertElement(amount, type, true);
        this.extractElement(Math.round((float)amount / multiplier), type, false);
        other.insertElement(amount, type, false);
        return amount;
    }

    default public boolean canPipeInsert(ElementType type) {
        return type != ElementType.NONE;
    }

    default public boolean canPipeExtract(ElementType type) {
        return type != ElementType.NONE;
    }

    default public boolean doesRenderGauge() {
        return false;
    }

    default public boolean usableInInventory() {
        return false;
    }

    default public boolean isEmpty() {
        return ElementType.allValid().stream().mapToInt(this::getElementAmount).allMatch(i -> i <= 0);
    }
}

