/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;

public class SingleElementStorage
implements ISingleElementStorage {
    protected int elementAmount;
    protected int elementCapacity;
    protected ElementType elementType;
    private final Runnable syncCallback;

    public SingleElementStorage(int elementCapacity) {
        this(elementCapacity, null);
    }

    public SingleElementStorage(int elementCapacity, Runnable syncCallback) {
        this(ElementType.NONE, 0, elementCapacity, syncCallback);
    }

    public SingleElementStorage(ElementType elementType, int elementAmount, int elementCapacity) {
        this(elementType, elementAmount, elementCapacity, null);
    }

    private SingleElementStorage(ElementType elementType, int elementAmount, int elementCapacity, Runnable syncCallback) {
        this.elementCapacity = elementCapacity;
        this.elementAmount = elementAmount;
        this.elementType = elementType;
        this.syncCallback = syncCallback;
    }

    @Nullable
    public static ICapabilityProvider createProvider(SingleElementStorage storage) {
        return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY != null ? new CapabilityProvider(storage) : null;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getElementCapacity() {
        return this.elementCapacity;
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType && this.elementType != ElementType.NONE) {
            return count - this.extractElement(count, simulate);
        }
        int newCount = Math.min(this.elementAmount + count, this.elementCapacity);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementType == ElementType.NONE) {
                this.elementType = type;
            }
            if (ret < count) {
                this.markDirty();
            }
        }
        return ret;
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType) {
            return 0;
        }
        int newCount = Math.max(this.elementAmount - count, 0);
        int ret = this.elementAmount - newCount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementAmount <= 0) {
                this.elementType = ElementType.NONE;
            }
            if (ret > 0) {
                this.markDirty();
            }
        }
        return ret;
    }

    public void markDirty() {
        if (this.syncCallback != null) {
            this.syncCallback.run();
        }
    }

    public String toString() {
        return this.elementAmount + "/" + this.elementCapacity + " " + this.elementType.func_176610_l();
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("element_type", this.getElementType().func_176610_l());
        compound.func_74768_a("element_amount", this.getElementAmount());
        compound.func_74768_a("element_capacity", this.getElementCapacity());
        return compound;
    }

    public void readNBT(CompoundNBT compound) {
        this.elementType = ElementType.byName(compound.func_74779_i("element_type"));
        this.elementAmount = compound.func_74762_e("element_amount");
        this.elementCapacity = compound.func_74762_e("element_capacity");
    }

    private static class CapabilityProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final SingleElementStorage storage;

        public CapabilityProvider(SingleElementStorage storage) {
            this.storage = storage;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.storage));
        }

        public CompoundNBT serializeNBT() {
            return this.storage.writeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.storage.readNBT(nbt);
        }
    }
}

