/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.AbstractBlockECTileProvider;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public abstract class AbstractBlockECContainer
extends AbstractBlockECTileProvider {
    protected AbstractBlockECContainer() {
    }

    protected AbstractBlockECContainer(AbstractBlock.Properties properties) {
        super(properties);
    }

    private boolean canInsertStack(IItemHandler inventory, ItemStack stack, ItemStack heldItem, int slot) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)heldItem) && stack.func_190916_E() < stack.func_77976_d() && stack.func_190916_E() < inventory.getSlotLimit(slot);
    }

    public ActionResultType onSlotActivated(IItemHandler inventory, PlayerEntity player, ItemStack heldItem, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        World world = player.func_130014_f_();
        if (heldItem.func_190926_b() || player.func_225608_bj_() || !stack.func_190926_b() && !this.canInsertStack(inventory, stack, heldItem, slot)) {
            if (!stack.func_190926_b()) {
                if (!world.func_201670_d()) {
                    ItemStack extracted = inventory.extractItem(slot, stack.func_190916_E(), false);
                    world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.25, player.func_226281_cx_(), extracted));
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (stack.func_190926_b() && inventory.isItemValid(slot, heldItem)) {
            int size = Math.min(heldItem.func_190916_E(), inventory.getSlotLimit(slot));
            stack = heldItem.func_77946_l();
            stack.func_190920_e(size);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(size);
            }
            inventory.insertItem(slot, stack, false);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && this.canInsertStack(inventory, stack, heldItem, slot)) {
            int size = Math.min(heldItem.func_190916_E(), inventory.getSlotLimit(slot) - stack.func_190916_E());
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(size);
            }
            stack.func_190917_f(size);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected ActionResultType onSingleSlotActivated(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)world, pos, null);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!(inv == null || hand != Hand.MAIN_HAND && heldItem.func_190926_b())) {
            return this.onSlotActivated(inv, player, heldItem, 0);
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }
}

