/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.evaporator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.evaporator.BlockEvaporator;
import sirttas.elementalcraft.block.tile.AbstractTileECContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleStackInventory;
import sirttas.elementalcraft.item.elemental.ItemShard;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public class TileEvaporator
extends AbstractTileECContainer {
    @ObjectHolder(value="elementalcraft:evaporator")
    public static final TileEntityType<TileEvaporator> TYPE = null;
    private final SingleStackInventory inventory = new SingleStackInventory(this::func_70296_d);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;

    public TileEvaporator() {
        super(TYPE);
        this.elementStorage = new SingleElementStorage((Integer)ECConfig.COMMON.shardElementAmount.get() * 20, this::func_70296_d);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.evaporatorMaxRunes.get());
    }

    @Override
    public void func_73660_a() {
        ItemStack stack = this.inventory.func_70301_a(0);
        Item item = stack.func_77973_b();
        ElementType type = BlockEvaporator.getShardElementType(stack);
        float extractionAmount = this.runeHandler.getTransferSpeed(((Integer)ECConfig.COMMON.evaporatorExtractionAmount.get()).intValue());
        super.func_73660_a();
        if (type != ElementType.NONE && (float)this.elementStorage.getElementAmount() <= extractionAmount) {
            this.elementStorage.insertElement(this.getShardElementAmount((ItemShard)item), type, false);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.inventory.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
        if (this.canExtract()) {
            this.elementStorage.transferTo((IElementStorage)this.getTank(), extractionAmount, this.runeHandler.getElementPreservation());
        }
    }

    public boolean canExtract() {
        ISingleElementStorage tank = this.getTank();
        return !this.elementStorage.isEmpty() && this.func_145830_o() && tank != null && (tank.getElementAmount() < tank.getElementCapacity() || tank.getElementType() != this.elementStorage.getElementType());
    }

    private int getShardElementAmount(ItemShard item) {
        return Math.round((float)((Integer)ECConfig.COMMON.shardElementAmount.get() * item.getElementAmount()) * this.runeHandler.getElementPreservation());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            this.elementStorage.readNBT(compound.func_74775_l("element_storage"));
        } else {
            this.elementStorage.readNBT(compound);
        }
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", (INBT)this.elementStorage.writeNBT());
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

