/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.source.TileSource;
import sirttas.elementalcraft.block.tile.AbstractTileECTickable;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public class TileExtractor
extends AbstractTileECTickable {
    @ObjectHolder(value="elementalcraft:extractor")
    public static final TileEntityType<TileExtractor> TYPE = null;
    private int extractionAmount;
    private final RuneHandler runeHandler;

    public TileExtractor() {
        this(false);
    }

    public TileExtractor(boolean improved) {
        super(TYPE);
        if (improved) {
            this.extractionAmount = (Integer)ECConfig.COMMON.improvedExtractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.improvedExtractorMaxRunes.get());
        } else {
            this.extractionAmount = (Integer)ECConfig.COMMON.extractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.extractorMaxRunes.get());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.extractionAmount = compound.func_74762_e("extraction_amount");
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("extraction_amount", this.extractionAmount);
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    protected Optional<BlockState> getSourceState() {
        return this.func_145830_o() ? Optional.of(this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a())) : Optional.empty();
    }

    public ElementType getSourceElementType() {
        return this.getSourceState().filter(s -> s.func_177230_c() == ECBlocks.SOURCE).map(ElementType::getElementType).orElse(ElementType.NONE);
    }

    @Override
    public void func_73660_a() {
        ElementType sourceElementType = this.getSourceElementType();
        super.func_73660_a();
        if (this.canExtract(sourceElementType)) {
            TileEntityHelper.getTileEntityAs((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a(), TileSource.class).map(TileSource::getElementStorage).ifPresent(sourceStorage -> sourceStorage.transferTo((IElementStorage)this.getTank(), this.runeHandler.getTransferSpeed(this.extractionAmount), this.runeHandler.getElementPreservation()));
        }
    }

    public boolean canExtract() {
        return this.canExtract(this.getSourceElementType());
    }

    private boolean canExtract(ElementType sourceElementType) {
        ISingleElementStorage tank = this.getTank();
        return this.func_145830_o() && sourceElementType != ElementType.NONE && tank != null && (tank.getElementAmount() < tank.getElementCapacity() || tank.getElementType() != sourceElementType);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

