/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.instrument.IInstrument;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.tile.AbstractTileECCrafting;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public abstract class AbstractTileInstrument<T extends IInstrument, R extends IInstrumentRecipe<T>>
extends AbstractTileECCrafting<T, R>
implements IInstrument {
    private int progress = 0;
    private final RuneHandler runeHandler;

    protected AbstractTileInstrument(TileEntityType<?> tileEntityTypeIn, IRecipeType<R> recipeType, int transferSpeed, int maxRunes) {
        super(tileEntityTypeIn, recipeType, transferSpeed);
        this.runeHandler = maxRunes > 0 ? new RuneHandler(maxRunes) : null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.isPowered() && this.progressOnTick()) {
            this.makeProgress();
        }
        if (this.shouldRetriverExtractOutput()) {
            BlockRetriever.sendOutputToRetriever(this.field_145850_b, this.field_174879_c, this.getInventory(), this.outputSlot);
        }
    }

    protected boolean shouldRetriverExtractOutput() {
        return true;
    }

    protected boolean progressOnTick() {
        return true;
    }

    protected boolean makeProgress() {
        ISingleElementStorage tank = this.getTank();
        if (this.recipe != null && this.progress >= this.recipe.getElementAmount()) {
            this.process();
            this.progress = 0;
            return true;
        }
        if (this.isRecipeAvailable() && tank != null) {
            float preservation = this.runeHandler.getElementPreservation();
            int oldProgress = this.progress;
            this.progress = (int)((float)this.progress + (float)tank.extractElement(Math.min(Math.round(this.runeHandler.getTransferSpeed(this.transferSpeed) / preservation), tank.getElementAmount() - 1), this.getRecipeElementType(), false) * preservation);
            if (this.progress > 0 && this.progress / this.transferSpeed >= oldProgress / this.transferSpeed) {
                this.onProgress();
            }
            return true;
        }
        if (this.recipe == null) {
            this.progress = 0;
        }
        return false;
    }

    private ElementType getRecipeElementType() {
        if (this.recipe instanceof IElementTypeProvider) {
            return ((IElementTypeProvider)((Object)this.recipe)).getElementType();
        }
        return ElementType.NONE;
    }

    protected void onProgress() {
        if (this.field_145850_b.field_72995_K) {
            ParticleHelper.createElementFlowParticle(this.getElementType(), this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), Direction.UP, 1, this.field_145850_b.field_73012_v);
        }
    }

    @Override
    public ElementType getElementType() {
        ElementType tankType = this.getTankElementType();
        return tankType != ElementType.NONE || this.recipe == null ? tankType : this.getRecipeElementType();
    }

    @Override
    public boolean isRunning() {
        return this.progress > 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.progress = compound.func_74762_e("progress");
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.progress = 0;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public float getProgressRatio() {
        return (float)this.progress / (float)this.recipe.getElementAmount();
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

