/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.firefurnace;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.block.instrument.AbstractTileInstrument;
import sirttas.elementalcraft.inventory.IOInventory;
import sirttas.elementalcraft.inventory.InventoryTileWrapper;
import sirttas.elementalcraft.recipe.instrument.io.FurnaceRecipeWrapper;

public abstract class AbstractTileFireFurnace<T extends AbstractCookingRecipe>
extends AbstractTileInstrument<AbstractTileFireFurnace<T>, FurnaceRecipeWrapper<T>> {
    private float exp;
    private IRecipeType<T> furnaceRecipeType;
    private final IOInventory inventory;

    protected AbstractTileFireFurnace(TileEntityType<? extends AbstractTileFireFurnace<T>> tileEntityTypeIn, IRecipeType<T> recipeType, int transferSpeed, int maxRunes) {
        super(tileEntityTypeIn, null, transferSpeed, maxRunes);
        this.furnaceRecipeType = recipeType;
        this.exp = 0.0f;
        this.outputSlot = 1;
        this.inventory = new IOInventory(this::func_70296_d);
    }

    @Override
    protected IItemHandler createHandler() {
        return new SidedInvWrapper((ISidedInventory)this.inventory, null);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.exp = compound.func_74760_g("experience");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("experience", this.exp);
        return compound;
    }

    @Override
    protected FurnaceRecipeWrapper<T> lookupRecipe() {
        return this.func_145831_w().func_199532_z().func_215371_a(this.furnaceRecipeType, InventoryTileWrapper.from(this), this.func_145831_w()).map(FurnaceRecipeWrapper::new).orElse(null);
    }

    @Override
    protected void onProgress() {
        if (this.field_145850_b.field_72995_K) {
            Random rand = this.field_145850_b.field_73012_v;
            double x = (double)this.field_174879_c.func_177958_n() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
            double y = (double)this.field_174879_c.func_177956_o() + 0.375;
            double z = (double)this.field_174879_c.func_177952_p() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y + 0.5, z, 0.0, 0.0, 0.0);
        }
        super.onProgress();
    }

    public void dropExperience(PlayerEntity player) {
        this.dropExperience(player.func_213303_ch());
    }

    public void dropExperience(Vector3d pos) {
        while (this.exp > 0.0f) {
            int j = ExperienceOrbEntity.func_70527_a((int)((int)this.exp));
            this.exp -= (float)j;
            this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, pos.func_82615_a(), pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, j));
        }
        this.exp = 0.0f;
    }

    public void addExperience(float exp) {
        this.exp += exp;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }
}

