/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.pipe.BlockElementPipe;
import sirttas.elementalcraft.block.tile.AbstractTileECTickable;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.config.ECConfig;

public class TileElementPipe
extends AbstractTileECTickable {
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static final TileEntityType<TileElementPipe> TYPE = null;
    private Map<Direction, ConnectionType> connections = new EnumMap<Direction, ConnectionType>(Direction.class);
    private boolean updateState = true;
    private int transferedAmount = 0;
    private int maxTransferAmount;
    private BlockState coverState;

    public TileElementPipe() {
        this((Integer)ECConfig.COMMON.pipeTransferAmount.get());
    }

    public TileElementPipe(int maxTransferAmount) {
        super(TYPE);
        this.maxTransferAmount = maxTransferAmount;
    }

    private Optional<TileEntity> getAdjacentTile(Direction face) {
        return this.func_145830_o() ? TileEntityHelper.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(face)) : Optional.empty();
    }

    private ConnectionType getConection(Direction face) {
        if (this.connections.containsKey(face)) {
            return this.connections.get(face);
        }
        return ConnectionType.NONE;
    }

    private void setConection(Direction face, ConnectionType type) {
        this.connections.put(face, type);
        this.func_70296_d();
        this.updateState = true;
    }

    private void refresh(Direction face) {
        this.setConection(face, this.getAdjacentTile(face).map(tile -> {
            ConnectionType connection = this.getConection(face);
            if (connection != ConnectionType.NONE) {
                return connection;
            }
            if (tile instanceof TileElementPipe) {
                return ConnectionType.CONNECT;
            }
            return CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d()).map(storage -> {
                if (this.canInsertInStorage((IElementStorage)storage)) {
                    return ConnectionType.INSERT;
                }
                if (this.canExtractFromStorage((IElementStorage)storage)) {
                    return ConnectionType.EXTRACT;
                }
                return ConnectionType.NONE;
            }).orElse(ConnectionType.NONE);
        }).orElse(ConnectionType.NONE));
    }

    public void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    private void transferElement(IElementStorage sender, ElementType type) {
        Path path;
        IElementStorage receiver;
        int amount = this.maxTransferAmount - this.transferedAmount;
        if (type != ElementType.NONE && (receiver = (path = new Path(sender)).searchReceiver(this, type, sender.extractElement(amount, type, true))) != null) {
            int remainingAmount = path.amount - sender.transferTo(receiver, type, path.amount);
            path.pipes.forEach(p -> p.transferedAmount += remainingAmount);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.refresh();
        this.transferedAmount = 0;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.connections.forEach((side, connection) -> {
                if (connection == ConnectionType.EXTRACT) {
                    this.getAdjacentTile((Direction)side).map(tile -> CapabilityElementStorage.get((ICapabilityProvider)tile, side.func_176734_d())).orElseGet(LazyOptional::empty).ifPresent(sender -> {
                        if (sender instanceof IElementTypeProvider) {
                            this.transferElement((IElementStorage)sender, ((IElementTypeProvider)((Object)sender)).getElementType());
                        }
                    });
                }
            });
        }
        if (this.updateState && this.func_145830_o()) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_145831_w().func_180495_p(this.field_174879_c).func_206870_a(BlockElementPipe.NORTH, (Comparable)((Object)this.getConection(Direction.NORTH).getStateConnection()))).func_206870_a(BlockElementPipe.EAST, (Comparable)((Object)this.getConection(Direction.EAST).getStateConnection()))).func_206870_a(BlockElementPipe.SOUTH, (Comparable)((Object)this.getConection(Direction.SOUTH).getStateConnection()))).func_206870_a(BlockElementPipe.WEST, (Comparable)((Object)this.getConection(Direction.WEST).getStateConnection()))).func_206870_a(BlockElementPipe.UP, (Comparable)((Object)this.getConection(Direction.UP).getStateConnection()))).func_206870_a(BlockElementPipe.DOWN, (Comparable)((Object)this.getConection(Direction.DOWN).getStateConnection())));
            this.updateState = false;
        }
    }

    public ActionResultType activatePipe(Direction face) {
        return this.getAdjacentTile(face).map(tile -> {
            ConnectionType connection = this.getConection(face);
            switch (connection) {
                case INSERT: {
                    if (CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d()).filter(this::canExtractFromStorage).isPresent()) {
                        this.setConection(face, ConnectionType.EXTRACT);
                    } else {
                        this.setConection(face, ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case EXTRACT: 
                case CONNECT: {
                    this.setConection(face, ConnectionType.DISCONNECT);
                    if (tile instanceof TileElementPipe) {
                        ((TileElementPipe)((Object)tile)).setConection(face.func_176734_d(), ConnectionType.DISCONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
                case DISCONNECT: {
                    LazyOptional<IElementStorage> cap = CapabilityElementStorage.get((ICapabilityProvider)tile, face.func_176734_d());
                    if (cap.filter(this::canInsertInStorage).isPresent()) {
                        this.setConection(face, ConnectionType.INSERT);
                    } else if (cap.filter(this::canExtractFromStorage).isPresent()) {
                        this.setConection(face, ConnectionType.EXTRACT);
                    } else if (tile instanceof TileElementPipe) {
                        this.setConection(face, ConnectionType.CONNECT);
                        ((TileElementPipe)((Object)tile)).setConection(face.func_176734_d(), ConnectionType.CONNECT);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    private boolean canInsertInStorage(IElementStorage storage) {
        return ElementType.allValid().stream().anyMatch(storage::canPipeInsert);
    }

    private boolean canExtractFromStorage(IElementStorage storage) {
        return ElementType.allValid().stream().anyMatch(storage::canPipeExtract);
    }

    public ITextComponent getConnectionMessage(Direction face) {
        return this.getConection(face).getDisplayName();
    }

    public BlockState getCoverState() {
        return this.coverState;
    }

    public ActionResultType setCover(PlayerEntity player, Hand hand) {
        BlockState state;
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem && !stack.func_190926_b() && (state = ((BlockItem)item).func_179223_d().func_176223_P()) != this.coverState) {
            if (this.coverState != null) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)this.coverState.func_177230_c()));
            }
            this.coverState = state;
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.field_174879_c).func_206870_a(BlockElementPipe.COVER, (Comparable)((Object)BlockElementPipe.CoverType.COVERED)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        for (Direction face : Direction.values()) {
            this.setConection(face, ConnectionType.fromInteger(compound.func_74762_e(face.func_176610_l())));
        }
        this.maxTransferAmount = compound.func_74762_e("max_transfer_amount");
        this.coverState = compound.func_74764_b("cover") ? NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("cover")) : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.connections.forEach((k, v) -> compound.func_74768_a(k.func_176610_l(), v.getValue()));
        compound.func_74768_a("max_transfer_amount", this.maxTransferAmount);
        if (this.coverState != null) {
            compound.func_218657_a("cover", (INBT)NBTUtil.func_190009_a((BlockState)this.coverState));
        } else if (compound.func_74764_b("cover")) {
            compound.func_82580_o("cover");
        }
        return compound;
    }

    private static class Path {
        private final IElementStorage sender;
        List<TileElementPipe> visited = Lists.newArrayListWithCapacity((int)100);
        List<TileElementPipe> pipes = Lists.newArrayListWithCapacity((int)100);
        int amount;

        public Path(IElementStorage sender) {
            this.sender = sender;
        }

        private IElementStorage searchReceiver(TileElementPipe pipe, ElementType type, int lastCount) {
            int count = Math.min(lastCount, pipe.maxTransferAmount - pipe.transferedAmount);
            if (count > 0 && !this.visited.contains((Object)pipe)) {
                this.visited.add(pipe);
                return pipe.connections.entrySet().stream().filter(entry -> {
                    ConnectionType connection = (ConnectionType)((Object)((Object)entry.getValue()));
                    return connection == ConnectionType.CONNECT || connection == ConnectionType.INSERT;
                }).sorted((c1, c2) -> ((ConnectionType)((Object)((Object)c1.getValue()))).value - ((ConnectionType)((Object)((Object)c2.getValue()))).value).map(entry -> {
                    Direction side = (Direction)entry.getKey();
                    ConnectionType connection = (ConnectionType)((Object)((Object)entry.getValue()));
                    return pipe.getAdjacentTile(side).map(entity -> {
                        LazyOptional<IElementStorage> cap;
                        if (entity instanceof TileElementPipe && connection == ConnectionType.CONNECT) {
                            IElementStorage ret = this.searchReceiver((TileElementPipe)((Object)((Object)entity)), type, count);
                            if (ret != null) {
                                this.pipes.add(pipe);
                                return ret;
                            }
                        } else if (entity != null && connection == ConnectionType.INSERT && (cap = CapabilityElementStorage.get((ICapabilityProvider)entity, side.func_176734_d())).filter(receiver -> receiver != this.sender && receiver.canPipeInsert(type) && receiver.insertElement(count, type, true) < count).isPresent()) {
                            this.amount = count;
                            this.pipes.add(pipe);
                            return (IElementStorage)cap.orElse(null);
                        }
                        return null;
                    });
                }).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null);
            }
            return null;
        }
    }

    private static enum ConnectionType {
        NONE(0, "none", BlockElementPipe.ConnectionType.NONE),
        CONNECT(1, "connect", BlockElementPipe.ConnectionType.CONNECTED),
        INSERT(2, "insert", BlockElementPipe.ConnectionType.CONNECTED),
        EXTRACT(3, "extract", BlockElementPipe.ConnectionType.EXTRACT),
        DISCONNECT(4, "disconnect", BlockElementPipe.ConnectionType.NONE);

        private BlockElementPipe.ConnectionType stateConnection;
        private final int value;
        private final String translationKey;

        private ConnectionType(int value, String key, BlockElementPipe.ConnectionType stateConnection) {
            this.value = value;
            this.translationKey = "message.elementalcraft." + key;
            this.stateConnection = stateConnection;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionType fromInteger(int x) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.getValue() != x) continue;
                return type;
            }
            return NONE;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent(this.translationKey);
        }

        public BlockElementPipe.ConnectionType getStateConnection() {
            return this.stateConnection;
        }
    }
}

