/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.BooleanUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.block.pureinfuser.pedestal.BlockPedestal;
import sirttas.elementalcraft.block.tile.renderer.ECRenderTypes;
import sirttas.elementalcraft.block.tile.renderer.SingleItemRenderer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.event.TickHandler;

public class RendererPureInfuser
extends SingleItemRenderer<TilePureInfuser> {
    public RendererPureInfuser(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher, new Vector3d(0.5, 0.9, 0.5));
    }

    public void render(TilePureInfuser te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        Map<Direction, ElementType> map;
        List<ElementType> remaining;
        if (BooleanUtils.isTrue((Boolean)((Boolean)ECConfig.CLIENT.renderPedestalShadow.get())) && !(remaining = this.getRemainingElements(map = this.getDirectionMap(te))).isEmpty()) {
            map.entrySet().stream().filter(entry -> entry.getValue() == ElementType.NONE).map(Map.Entry::getKey).forEach(direction -> {
                ElementType type = (ElementType)remaining.get((int)(((float)TickHandler.getTicksInGame() + partialTicks) / 20.0f % (float)remaining.size()));
                Block pedestal = this.getPedestalForType(type);
                if (pedestal != null) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_((double)direction.func_82601_c() * 3.0, 0.0, (double)direction.func_82599_e() * 3.0);
                    this.renderBlock(pedestal.func_176223_P(), matrixStack, buffer.getBuffer(ECRenderTypes.GHOST), te.func_145831_w());
                    matrixStack.func_227865_b_();
                    remaining.remove(type);
                }
            });
        }
        super.func_225616_a_(te, partialTicks, matrixStack, buffer, light, overlay);
    }

    private List<ElementType> getRemainingElements(Map<Direction, ElementType> map) {
        List usedElements = map.values().stream().filter(elementType -> elementType != ElementType.NONE).collect(Collectors.toList());
        return ElementType.allValid().stream().filter(type -> !usedElements.contains(type)).collect(Collectors.toList());
    }

    private Map<Direction, ElementType> getDirectionMap(TilePureInfuser te) {
        EnumMap<Direction, ElementType> map = new EnumMap<Direction, ElementType>(Direction.class);
        map.put(Direction.NORTH, this.getPedestal(te, Direction.NORTH));
        map.put(Direction.SOUTH, this.getPedestal(te, Direction.SOUTH));
        map.put(Direction.WEST, this.getPedestal(te, Direction.WEST));
        map.put(Direction.EAST, this.getPedestal(te, Direction.EAST));
        return map;
    }

    private ElementType getPedestal(TilePureInfuser te, Direction direction) {
        BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v().func_177967_a(direction, 3));
        Block block = state.func_177230_c();
        return block instanceof BlockPedestal ? ((BlockPedestal)block).getElementType() : ElementType.NONE;
    }

    private Block getPedestalForType(ElementType type) {
        switch (type) {
            case WATER: {
                return ECBlocks.WATER_PEDESTAL;
            }
            case FIRE: {
                return ECBlocks.FIRE_PEDESTAL;
            }
            case EARTH: {
                return ECBlocks.EARTH_PEDESTAL;
            }
            case AIR: {
                return ECBlocks.AIR_PEDESTAL;
            }
        }
        return null;
    }
}

