/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.pureinfuser.pedestal.TilePedestal;
import sirttas.elementalcraft.block.tile.AbstractTileECCrafting;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleItemInventory;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.rune.Rune;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public class TilePureInfuser
extends AbstractTileECCrafting<TilePureInfuser, PureInfusionRecipe> {
    @ObjectHolder(value="elementalcraft:pureinfuser")
    public static final TileEntityType<TilePureInfuser> TYPE = null;
    private final SingleItemInventory inventory;
    private final Map<Direction, Integer> progress = new EnumMap<Direction, Integer>(Direction.class);
    private final RuneHandler runeHandler;

    public TilePureInfuser() {
        super(TYPE, PureInfusionRecipe.TYPE, (Integer)ECConfig.COMMON.pureInfuserTransferSpeed.get());
        this.inventory = new SingleItemInventory(this::func_70296_d);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pureInfuserMaxRunes.get());
        this.progress.put(Direction.NORTH, 0);
        this.progress.put(Direction.SOUTH, 0);
        this.progress.put(Direction.WEST, 0);
        this.progress.put(Direction.EAST, 0);
    }

    @Override
    public void process() {
        super.process();
        if (this.field_145850_b.field_72995_K) {
            ParticleHelper.createCraftingParticle(ElementType.NONE, this.field_145850_b, Vector3d.func_237489_a_((Vector3i)this.field_174879_c).func_72441_c(0.0, 0.7, 0.0), this.field_145850_b.field_73012_v);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.isPowered()) {
            this.makeProgress();
        }
    }

    protected void makeProgress() {
        if (this.recipe != null && this.getProgress(Direction.NORTH) >= this.recipe.getElementAmount() && this.getProgress(Direction.SOUTH) >= this.recipe.getElementAmount() && this.getProgress(Direction.WEST) >= this.recipe.getElementAmount() && this.getProgress(Direction.EAST) >= this.recipe.getElementAmount()) {
            this.process();
            this.progress.clear();
        } else if (this.isRecipeAvailable()) {
            this.makeProgress(Direction.NORTH);
            this.makeProgress(Direction.SOUTH);
            this.makeProgress(Direction.WEST);
            this.makeProgress(Direction.EAST);
        } else if (this.recipe == null) {
            this.progress.clear();
        }
    }

    public ItemStack getStackInPedestal(ElementType type) {
        TilePedestal pedestal = this.getPedestal(type);
        return pedestal != null ? pedestal.getItem() : ItemStack.field_190927_a;
    }

    public TilePedestal getPedestal(ElementType type) {
        TilePedestal pedestal = this.getPedestal(Direction.NORTH);
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.SOUTH);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.WEST);
        }
        if (pedestal == null || pedestal.getElementType() != type) {
            pedestal = this.getPedestal(Direction.EAST);
        }
        return pedestal != null && pedestal.getElementType() == type ? pedestal : null;
    }

    public void emptyPedestals() {
        this.setPedestalInventory(Direction.NORTH, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.SOUTH, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.WEST, ItemStack.field_190927_a);
        this.setPedestalInventory(Direction.EAST, ItemStack.field_190927_a);
    }

    private void setPedestalInventory(Direction direction, ItemStack stack) {
        TilePedestal pedestal = this.getPedestal(direction);
        if (pedestal != null) {
            pedestal.getInventory().func_70299_a(0, stack);
            pedestal.func_70296_d();
        }
    }

    private TilePedestal getPedestal(Direction direction) {
        TileEntity te = this.func_145830_o() ? this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(direction, 3)) : null;
        return te instanceof TilePedestal ? (TilePedestal)te : null;
    }

    private void makeProgress(Direction direction) {
        float transferAmount;
        TilePedestal pedestal = this.getPedestal(direction);
        Direction offset = direction.func_176734_d();
        int oldProgress = this.getProgress(direction);
        if (pedestal != null && (transferAmount = Math.min(this.getTransferSpeed(pedestal), (float)this.recipe.getElementAmount() - (float)oldProgress)) > 0.0f) {
            float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
            float newProgress = (float)oldProgress + (float)pedestal.getElementStorage().extractElement(Math.round(transferAmount / preservation), false) * preservation;
            this.progress.put(direction, Math.round(newProgress));
            if (this.field_145850_b.field_72995_K && newProgress > 0.0f && newProgress / transferAmount >= (float)oldProgress / transferAmount) {
                ParticleHelper.createElementFlowParticle(pedestal.getElementType(), this.field_145850_b, Vector3d.func_237489_a_((Vector3i)pedestal.func_174877_v().func_177967_a(offset, 2)).func_72441_c(0.0, 0.7, 0.0), offset, 2, this.field_145850_b.field_73012_v);
            }
        }
    }

    private float getTransferSpeed(TilePedestal pedestal) {
        return (float)this.transferSpeed * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    public int getProgress(Direction direction) {
        return this.progress.getOrDefault(direction, 0);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public boolean isRunning() {
        return this.progress.values().stream().anyMatch(i -> i > 0);
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        int[] progressArray = compound.func_74759_k("progress");
        for (int i = 0; i < progressArray.length; ++i) {
            this.progress.put(Direction.func_176731_b((int)i), progressArray[i]);
        }
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74783_a("progress", this.progress.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).func_176736_b())).mapToInt(Map.Entry::getValue).toArray());
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

