/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.pureinfuser.TilePureInfuser;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalElementStorage;
import sirttas.elementalcraft.block.tile.AbstractTileECContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleItemInventory;
import sirttas.elementalcraft.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.rune.handler.RuneHandler;

public class TilePedestal
extends AbstractTileECContainer
implements IElementTypeProvider {
    @ObjectHolder(value="elementalcraft:pedestal_fire")
    public static final TileEntityType<TilePedestal> TYPE_FIRE = null;
    @ObjectHolder(value="elementalcraft:pedestal_water")
    public static final TileEntityType<TilePedestal> TYPE_WATER = null;
    @ObjectHolder(value="elementalcraft:pedestal_earth")
    public static final TileEntityType<TilePedestal> TYPE_EARTH = null;
    @ObjectHolder(value="elementalcraft:pedestal_air")
    public static final TileEntityType<TilePedestal> TYPE_AIR = null;
    private final SingleItemInventory inventory = new SingleItemInventory(this::func_70296_d);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;

    private TilePedestal(TileEntityType<?> tileEntityType, ElementType type) {
        super(tileEntityType);
        this.elementStorage = new PedestalElementStorage(type, this::func_70296_d);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pedestalMaxRunes.get());
    }

    public static TilePedestal createFire() {
        return new TilePedestal(TYPE_FIRE, ElementType.FIRE);
    }

    public static TilePedestal createWater() {
        return new TilePedestal(TYPE_WATER, ElementType.WATER);
    }

    public static TilePedestal createEarth() {
        return new TilePedestal(TYPE_EARTH, ElementType.EARTH);
    }

    public static TilePedestal createAir() {
        return new TilePedestal(TYPE_AIR, ElementType.AIR);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("element_storage")) {
            this.elementStorage.readNBT(compound.func_74775_l("element_storage"));
        } else {
            this.elementStorage.readNBT(compound);
        }
        if (compound.func_74764_b("rune_handler")) {
            CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.readNBT((Object)this.runeHandler, null, compound.func_74781_a("rune_handler"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("element_storage", (INBT)this.elementStorage.writeNBT());
        compound.func_218657_a("rune_handler", CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY.writeNBT((Object)this.runeHandler, null));
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY && side != Direction.UP) {
                return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public Direction getPureInfuserDirection() {
        return Stream.of(Direction.values()).filter(d -> d.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL).filter(d -> this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(d, 3)) instanceof TilePureInfuser).findAny().orElse(Direction.UP);
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

