/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.firepylon;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractTileShrine;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

public class TileFirePylon
extends AbstractTileShrine {
    @ObjectHolder(value="elementalcraft:firepylon")
    public static final TileEntityType<TileFirePylon> TYPE = null;
    private static final AbstractTileShrine.Properties PROPERTIES = AbstractTileShrine.Properties.create(ElementType.FIRE).consumeAmount((Integer)ECConfig.COMMON.firePylonConsumeAmount.get()).range(((Integer)ECConfig.COMMON.firePylonRange.get()).intValue());
    protected static final List<Direction> UPGRRADE_DIRECTIONS = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);

    public TileFirePylon() {
        super(TYPE, PROPERTIES);
    }

    private List<LivingEntity> getEntities() {
        return this.func_145831_w().func_175647_a(LivingEntity.class, this.getRangeBoundingBox(), e -> !e.func_175149_v() && !e.func_70644_a(Effects.field_76426_n) && !e.func_70027_ad() && !ToolInfusionHelper.hasFireInfusion(e));
    }

    @Override
    protected boolean doTick() {
        int consumeAmount = this.getConsumeAmount();
        float strength = this.getMultiplier(ShrineUpgrade.BonusType.STRENGTH);
        this.getEntities().forEach(e -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                e.func_70097_a(DamageSource.field_76372_a, (float)((double)strength * (Double)ECConfig.COMMON.firePylonDamage.get()));
                e.func_70015_d((int)((float)this.consumeElement(consumeAmount) * strength));
            }
        });
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRRADE_DIRECTIONS;
    }
}

