/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.harvest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractTileShrine;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.loot.LootHelper;

public class TileHarvestShrine
extends AbstractTileShrine {
    @ObjectHolder(value="elementalcraft:harvestshrine")
    public static final TileEntityType<TileHarvestShrine> TYPE = null;
    private static final AbstractTileShrine.Properties PROPERTIES = AbstractTileShrine.Properties.create(ElementType.EARTH).periode((Double)ECConfig.COMMON.harvestShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.harvestShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.harvestShrineRange.get()).intValue());
    protected static final List<Direction> UPGRRADE_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);

    public TileHarvestShrine() {
        super(TYPE, PROPERTIES);
    }

    private Optional<BlockPos> findCrop() {
        int range = this.getIntegerRange();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(-3, 1).mapToObj(y -> new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(p -> {
            BlockState blockstate = this.field_145850_b.func_180495_p(p);
            Block block = blockstate.func_177230_c();
            return block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(blockstate);
        }).findAny();
    }

    private void handlePlanting(BlockPos pos, IItemProvider provider, List<ItemStack> loots) {
        Item item = provider.func_199767_j();
        if (this.hasUpgrade(ShrineUpgrades.PLANTING)) {
            loots.stream().filter(stack -> stack.func_77973_b().equals(item)).findFirst().ifPresent(seeds -> {
                if (item instanceof BlockItem && ((BlockItem)item).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_145850_b, pos, Direction.DOWN, seeds, Direction.UP)).func_226246_a_()) {
                    seeds.func_190918_g(1);
                    if (seeds.func_190926_b()) {
                        loots.remove(seeds);
                    }
                }
            });
        }
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72321_a(0.0, -2.0, 0.0).func_72317_d(0.0, -1.0, 0.0);
    }

    @Override
    protected boolean doTick() {
        if (this.field_145850_b instanceof ServerWorld && !this.field_145850_b.field_72995_K) {
            return this.findCrop().map(p -> {
                List<ItemStack> loots = LootHelper.getDrops((ServerWorld)this.field_145850_b, p);
                Block block = this.field_145850_b.func_180495_p(p).func_177230_c();
                this.field_145850_b.func_175655_b(p, false);
                this.handlePlanting((BlockPos)p, (IItemProvider)block, loots);
                loots.forEach(stack -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)p, (ItemStack)stack));
                return true;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRRADE_DIRECTIONS;
    }
}

