/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.ore;

import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractTileShrine;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.loot.LootHelper;

public class TileOreShrine
extends AbstractTileShrine {
    @ObjectHolder(value="elementalcraft:oreshrine")
    public static final TileEntityType<TileOreShrine> TYPE = null;
    private static final AbstractTileShrine.Properties PROPERTIES = AbstractTileShrine.Properties.create(ElementType.EARTH).periode((Double)ECConfig.COMMON.oreShrinePeriode.get()).consumeAmount((Integer)ECConfig.COMMON.oreShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.oreShrineRange.get()).intValue()).capacity((Integer)ECConfig.COMMON.shrinesCapacity.get() * 10);

    public TileOreShrine() {
        super(TYPE, PROPERTIES);
    }

    private Optional<BlockPos> findOre() {
        int range = this.getIntegerRange();
        return IntStream.range(-range, range + 1).mapToObj(x -> IntStream.range(-range, range + 1).mapToObj(z -> IntStream.range(0, this.field_174879_c.func_177956_o() + 1).mapToObj(y -> new BlockPos(this.field_174879_c.func_177958_n() + x, y, this.field_174879_c.func_177952_p() + z)))).flatMap(s -> s.flatMap(s2 -> s2)).filter(p -> Tags.Blocks.ORES.func_230235_a_((Object)this.field_145850_b.func_180495_p(p).func_177230_c())).findAny();
    }

    private boolean isSilkTouch() {
        return this.hasUpgrade(ShrineUpgrades.SILK_TOUCH);
    }

    private int getFortuneLevel() {
        return this.getUpgradeCount(ShrineUpgrades.FORTUNE);
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = this.getIntegerRange();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72317_d(0.0, -1.0, 0.0).func_72321_a(0.0, 1.0 - (double)this.field_174879_c.func_177956_o(), 0.0);
    }

    @Override
    protected boolean doTick() {
        if (this.field_145850_b instanceof ServerWorld && !this.field_145850_b.field_72995_K) {
            return this.findOre().map(p -> {
                int fortune = this.getFortuneLevel();
                if (fortune > 0) {
                    ItemStack pickaxe = new ItemStack((IItemProvider)Items.field_234756_kK_);
                    pickaxe.func_77966_a(Enchantments.field_185308_t, fortune);
                    LootHelper.getDrops((ServerWorld)this.field_145850_b, p, pickaxe).forEach(s -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (ItemStack)s));
                } else {
                    LootHelper.getDrops((ServerWorld)this.field_145850_b, p, this.isSilkTouch()).forEach(s -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (ItemStack)s));
                }
                this.field_145850_b.func_175656_a(p, Blocks.field_150348_b.func_176223_P());
                return true;
            }).orElse(false);
        }
        return false;
    }
}

