/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.vacuum;

import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractTileShrine;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.particle.ParticleHelper;

public class TileVacuumShrine
extends AbstractTileShrine {
    @ObjectHolder(value="elementalcraft:vacuumshrine")
    public static final TileEntityType<TileVacuumShrine> TYPE = null;
    private static final AbstractTileShrine.Properties PROPERTIES = AbstractTileShrine.Properties.create(ElementType.AIR).consumeAmount((Integer)ECConfig.COMMON.vacuumShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.vacuumShrineRange.get()).intValue());

    public TileVacuumShrine() {
        super(TYPE, PROPERTIES);
    }

    private List<ItemEntity> getEntities() {
        return this.func_145831_w().func_217357_a(ItemEntity.class, this.getRangeBoundingBox());
    }

    @Override
    protected boolean doTick() {
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), Direction.UP);
        return this.hasUpgrade(ShrineUpgrades.PICKUP) ? this.pickup(inv) : this.pull(inv);
    }

    private boolean pickup(IItemHandler inv) {
        return this.getEntities().stream().findAny().map(entity -> {
            this.doPickup(inv, (ItemEntity)entity);
            return true;
        }).orElse(false);
    }

    private boolean pull(IItemHandler inv) {
        int consumeAmount = this.getConsumeAmount();
        double pullSpeed = (Double)ECConfig.COMMON.vacuumShrinePullSpeed.get() * (double)this.getMultiplier(ShrineUpgrade.BonusType.STRENGTH);
        Vector3d pos3d = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
        this.getEntities().forEach(entity -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                this.consumeElement(consumeAmount);
                entity.func_213317_d(pos3d.func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(pullSpeed, pullSpeed, pullSpeed));
                if (pos3d.func_72438_d(entity.func_213303_ch()) <= (double)(2.0f * Math.max(1.0f, this.getMultiplier(ShrineUpgrade.BonusType.RANGE)))) {
                    this.doPickup(inv, (ItemEntity)entity);
                }
            }
        });
        return false;
    }

    private void doPickup(IItemHandler inv, ItemEntity entity) {
        entity.func_92058_a(ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)entity.func_92059_d(), (boolean)false));
        if (this.field_145850_b.field_72995_K) {
            ParticleHelper.createEnderParticle(this.field_145850_b, entity.func_213303_ch(), 3, this.field_145850_b.field_73012_v);
        }
    }
}

