/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.AbstractBlockECTileProvider;
import sirttas.elementalcraft.block.retriever.BlockRetriever;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.block.shape.Shapes;
import sirttas.elementalcraft.block.sorter.TileSorter;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class BlockSorter
extends AbstractBlockECTileProvider {
    public static final String NAME = "sorter";
    private static final VoxelShape CORE_VOID = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.func_208617_a((double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)11.0)});
    private static final VoxelShape CORE = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)CORE_VOID, (IBooleanFunction)IBooleanFunction.field_223234_e_), (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    public static final DirectionProperty SOURCE = BlockRetriever.SOURCE;
    public static final DirectionProperty TARGET = BlockRetriever.TARGET;

    public BlockSorter() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SOURCE, (Comparable)Direction.SOUTH)).func_206870_a((Property)TARGET, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SOURCE, (Comparable)direction.func_176734_d())).func_206870_a((Property)TARGET, (Comparable)direction);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSorter();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{SOURCE, TARGET});
    }

    private VoxelShape getSourceShape(BlockState state) {
        return Shapes.sourceShape((Direction)state.func_177229_b((Property)SOURCE));
    }

    private VoxelShape getTargetShape(BlockState state) {
        return Shapes.targetShape((Direction)state.func_177229_b((Property)TARGET));
    }

    private VoxelShape getCurentShape(BlockState state) {
        return VoxelShapes.func_216384_a((VoxelShape)this.getSourceShape(state), (VoxelShape[])new VoxelShape[]{this.getTargetShape(state), CORE}).func_197753_c();
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return worldIn instanceof World && ((World)worldIn).field_72995_K ? this.getShape(state, pos, Minecraft.func_71410_x().field_71476_x) : this.getCurentShape(state);
    }

    public VoxelShape getShape(BlockState state, BlockPos pos, RayTraceResult result) {
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
            Vector3d hit = result.func_216347_e();
            VoxelShape source = this.getSourceShape(state);
            VoxelShape target = this.getTargetShape(state);
            if (ShapeHelper.vectorCollideWithShape(source, pos, hit)) {
                return source;
            }
            if (ShapeHelper.vectorCollideWithShape(target, pos, hit)) {
                return target;
            }
            if (ShapeHelper.vectorCollideWithShape(CORE, pos, hit)) {
                return CORE;
            }
        }
        return this.getCurentShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getCurentShape(state);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        VoxelShape shape = this.getShape(state, pos, (RayTraceResult)hit);
        Direction direction = hit.func_216354_b().func_176734_d();
        if (CORE.equals(shape)) {
            return TileEntityHelper.getTileEntityAs((IBlockReader)world, pos, TileSorter.class).map(sorter -> sorter.addStack(player.func_184586_b(hand))).orElse(ActionResultType.PASS);
        }
        if (state.func_177229_b((Property)SOURCE) == direction || state.func_177229_b((Property)TARGET) == direction) {
            return ActionResultType.PASS;
        }
        if (Shapes.SOURCE_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SOURCE, (Comparable)direction));
            return ActionResultType.SUCCESS;
        }
        if (Shapes.TARGET_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)TARGET, (Comparable)direction));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void sendOutputToRetriever(World world, BlockPos pos, IInventory inventory, int slot) {
        ItemStack stack = inventory.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            for (Direction direction : Direction.values()) {
                BlockPos retriverPos = pos.func_177972_a(direction);
                BlockState blockState = world.func_180495_p(retriverPos);
                if (!(blockState.func_177230_c() instanceof BlockSorter) || blockState.func_177229_b((Property)SOURCE) != direction.func_176734_d()) continue;
                stack = BlockSorter.retrive(blockState, (IBlockReader)world, retriverPos, stack);
                inventory.func_70299_a(slot, stack);
                if (!stack.func_190926_b()) continue;
                return;
            }
        }
    }

    public static ItemStack retrive(BlockState state, IBlockReader world, BlockPos pos, ItemStack output) {
        Direction direction = (Direction)state.func_177229_b((Property)TARGET);
        return ItemHandlerHelper.insertItem((IItemHandler)ECInventoryHelper.getItemHandlerAt(world, pos.func_177972_a(direction), direction.func_176734_d()), (ItemStack)output, (boolean)false);
    }
}

