/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.block.sorter.BlockSorter;
import sirttas.elementalcraft.block.tile.AbstractTileECTickable;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class TileSorter
extends AbstractTileECTickable {
    @ObjectHolder(value="elementalcraft:sorter")
    public static final TileEntityType<TileSorter> TYPE = null;
    private static final Codec<List<ItemStack>> STACKS_CODEC = ItemStack.field_234691_a_.listOf().fieldOf("stacks").codec();
    private List<ItemStack> stacks = Lists.newArrayList();
    private int index = 0;
    private int tick = 0;
    private boolean alwaysInsert = false;

    public TileSorter() {
        super(TYPE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tick;
            if (this.tick > (Integer)ECConfig.COMMON.sorterCooldown.get()) {
                if (!this.isPowered()) {
                    this.transfer();
                }
                this.tick = 0;
            }
        }
    }

    public ActionResultType addStack(ItemStack stack) {
        if (!this.stacks.isEmpty() && stack.func_190926_b()) {
            this.stacks.clear();
            this.index = 0;
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        if (this.stacks.size() < (Integer)ECConfig.COMMON.sorterMaxItem.get()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            this.stacks.add(copy);
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public List<ItemStack> getStacks() {
        return ImmutableList.copyOf(this.stacks);
    }

    public int getIndex() {
        return this.index;
    }

    private void transfer() {
        block4: {
            IItemHandler targetInv;
            IItemHandler sourceInv;
            block3: {
                BlockState state = this.func_195044_w();
                Direction source = (Direction)state.func_177229_b((Property)BlockSorter.SOURCE);
                Direction target = (Direction)state.func_177229_b((Property)BlockSorter.TARGET);
                sourceInv = ECInventoryHelper.getItemHandlerAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(source), source.func_176734_d());
                targetInv = ECInventoryHelper.getItemHandlerAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(target), target.func_176734_d());
                if (!this.stacks.isEmpty()) break block3;
                for (int i = 0; i < sourceInv.getSlots(); ++i) {
                    ItemStack stack = sourceInv.getStackInSlot(i).func_77946_l();
                    stack.func_190920_e(1);
                    if (stack.func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    this.doTransfer(sourceInv, targetInv, i, stack);
                    return;
                }
                break block4;
            }
            if (this.index <= 0 && !ECInventoryHelper.isEmpty(targetInv) && !this.alwaysInsert) break block4;
            ItemStack stack = this.stacks.get(this.index).func_77946_l();
            for (int i = 0; i < sourceInv.getSlots(); ++i) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)sourceInv.getStackInSlot(i)) || !ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                this.doTransfer(sourceInv, targetInv, i, stack);
                ++this.index;
                if (this.index >= this.stacks.size()) {
                    this.index = 0;
                }
                return;
            }
        }
    }

    private void doTransfer(IItemHandler sourceInv, IItemHandler targetInv, int i, ItemStack stack) {
        sourceInv.extractItem(i, 1, false);
        ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)stack, (boolean)false);
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.stacks = Lists.newArrayList((Iterable)((Iterable)CodecHelper.decode(STACKS_CODEC, (INBT)compound)));
        this.index = compound.func_74762_e("index");
        if (this.index > this.stacks.size()) {
            this.index = 0;
        }
        this.alwaysInsert = compound.func_74767_n("always_insert");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        CompoundNBT value = (CompoundNBT)CodecHelper.handleResult((DataResult)STACKS_CODEC.encode(this.stacks, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound));
        compound.func_74768_a("index", this.index);
        compound.func_74757_a("always_insert", this.alwaysInsert);
        return value;
    }
}

