/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.block.AbstractBlockECTileProvider;
import sirttas.elementalcraft.block.source.TileSource;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.material.ECMaterials;
import sirttas.elementalcraft.particle.ParticleHelper;

public class BlockSource
extends AbstractBlockECTileProvider {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final String NAME = "source";

    public BlockSource() {
        super(AbstractBlock.Properties.func_200945_a((Material)ECMaterials.SOURCE).func_200948_a(-1.0f, 3600000.0f).func_235838_a_(s -> 7).func_226896_b_().func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ElementType.STATE_PROPERTY, (Comparable)((Object)ElementType.NONE)));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSource(ElementType.getElementType(state));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{ElementType.STATE_PROPERTY});
    }

    @Deprecated
    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.showShape(state, context) ? SHAPE : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    private boolean showShape(BlockState state, ISelectionContext context) {
        return Optional.ofNullable(context.getEntity()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> Stream.of(e.func_184614_ca(), e.func_184592_cb()).anyMatch(s -> s.func_77973_b() instanceof ISourceInteractable && ((ISourceInteractable)s.func_77973_b()).canIteractWithSource((ItemStack)s, state))).isPresent();
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (ElementType.getElementType(state) == ElementType.NONE) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(ElementType.STATE_PROPERTY, (Comparable)((Object)ElementType.random())));
        }
    }

    @Override
    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (!TileEntityHelper.getTileEntityAs((IBlockReader)world, pos, TileSource.class).isPresent()) {
            ParticleHelper.createSourceParticle(ElementType.getElementType(state), world, Vector3d.func_237489_a_((Vector3i)pos), rand);
        }
    }
}

