/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tank.reservoir;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.tank.AbstractBlockConnectedTank;
import sirttas.elementalcraft.block.tank.reservoir.TileReservoir;
import sirttas.elementalcraft.config.ECConfig;

public class BlockReservoir
extends AbstractBlockConnectedTank
implements IElementTypeProvider {
    public static final String NAME = "reservoir";
    public static final String NAME_FIRE = "reservoir_fire";
    public static final String NAME_WATER = "reservoir_water";
    public static final String NAME_EARTH = "reservoir_earth";
    public static final String NAME_AIR = "reservoir_air";
    private static final VoxelShape UPPER_GLASS = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape UPPER_PIPE_1 = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_2 = Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_3 = Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_PIPE_4 = Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_CONNECTOR = Block.func_208617_a((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UPPER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)UPPER_GLASS, (VoxelShape[])new VoxelShape[]{UPPER_PIPE_1, UPPER_PIPE_2, UPPER_PIPE_3, UPPER_PIPE_4, UPPER_CONNECTOR});
    private static final VoxelShape LOWER_GLASS_1 = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape LOWER_GLASS_2 = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape LOWER_PIPE_1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_2 = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_3 = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_PIPE_4 = Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_WALL_NORTH = Block.func_208617_a((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)9.0, (double)3.0);
    private static final VoxelShape LOWER_WALL_SOUTH = Block.func_208617_a((double)4.0, (double)2.0, (double)13.0, (double)12.0, (double)9.0, (double)15.0);
    private static final VoxelShape LOWER_WALL_WEST = Block.func_208617_a((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_WALL_EAST = Block.func_208617_a((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_PLATE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape LOWER_BASE = VoxelShapes.func_216384_a((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{LOWER_GLASS_2, LOWER_PIPE_1, LOWER_PIPE_2, LOWER_PIPE_3, LOWER_PIPE_4, LOWER_WALL_NORTH, LOWER_WALL_SOUTH, LOWER_WALL_WEST, LOWER_WALL_EAST, LOWER_PLATE});
    private static final VoxelShape EARTH_WALL_NORTH = Block.func_208617_a((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)14.0, (double)3.0);
    private static final VoxelShape EARTH_WALL_SOUTH = Block.func_208617_a((double)4.0, (double)9.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0);
    private static final VoxelShape EARTH_WALL_WEST = Block.func_208617_a((double)1.0, (double)9.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0);
    private static final VoxelShape EARTH_WALL_EAST = Block.func_208617_a((double)13.0, (double)9.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0);
    private static final VoxelShape LOWER_EARTH = VoxelShapes.func_216384_a((VoxelShape)LOWER_BASE, (VoxelShape[])new VoxelShape[]{EARTH_WALL_NORTH, EARTH_WALL_SOUTH, EARTH_WALL_WEST, EARTH_WALL_EAST});
    private static final VoxelShape AIR_PIPE_1 = Block.func_208617_a((double)1.0, (double)5.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_2 = Block.func_208617_a((double)13.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_3 = Block.func_208617_a((double)1.0, (double)5.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PIPE_4 = Block.func_208617_a((double)13.0, (double)5.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PLATE = Block.func_208617_a((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape AIR_PLATE_2 = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private static final VoxelShape LOWER_AIR = VoxelShapes.func_216384_a((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{AIR_PIPE_1, AIR_PIPE_2, AIR_PIPE_3, AIR_PIPE_4, AIR_PLATE, AIR_PLATE_2});
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    private final ElementType elementType;

    public BlockReservoir(ElementType elementType) {
        this.elementType = elementType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.getElementType()) {
            case AIR: {
                return TileReservoir.createAir();
            }
            case EARTH: {
                return TileReservoir.createEarth();
            }
            case FIRE: {
                return TileReservoir.createFire();
            }
            case WATER: {
                return TileReservoir.createWater();
            }
        }
        return null;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape;
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            shape = UPPER_SHAPE;
        } else {
            switch (this.getElementType()) {
                case AIR: {
                    shape = LOWER_AIR;
                    break;
                }
                case EARTH: {
                    shape = LOWER_EARTH;
                    break;
                }
                default: {
                    shape = LOWER_BASE;
                }
            }
        }
        return VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)super.func_220053_a(state, worldIn, pos, context));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{HALF, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    protected int getDefaultCapacity() {
        return (Integer)ECConfig.COMMON.reservoirCapacity.get();
    }

    @Override
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
        CompoundNBT tag = stack.func_190925_c("BlockEntityTag");
        tag.func_218657_a("element_storage", (INBT)new SingleElementStorage(this.getElementType(), this.getDefaultCapacity(), this.getDefaultCapacity()).writeNBT());
        items.add((Object)new ItemStack((IItemProvider)this.func_199767_j()));
        items.add((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            super.func_180655_c(stateIn, world, pos, rand);
        }
    }
}

