/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import sirttas.elementalcraft.block.tile.AbstractTileECTickable;
import sirttas.elementalcraft.inventory.IInventoryTile;

public abstract class AbstractTileECContainer
extends AbstractTileECTickable
implements IClearable,
IInventoryTile,
IInventoryChangedListener {
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::createHandler);

    protected AbstractTileECContainer(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_174888_l();
        super.onDataPacket(net, packet);
    }

    @Nonnull
    protected IItemHandler createHandler() {
        return new InvWrapper(this.getInventory());
    }

    @Override
    public void func_174888_l() {
        this.getInventory().func_174888_l();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        IInventory inv = this.getInventory();
        if (inv instanceof INBTSerializable && compound.func_74764_b("inventory")) {
            ((INBTSerializable)inv).deserializeNBT(compound.func_74781_a("inventory"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        IInventory inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            compound.func_218657_a("inventory", ((INBTSerializable)inv).serializeNBT());
        }
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public void func_76316_a(IInventory invBasic) {
        this.func_70296_d();
    }
}

