/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ECConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private ECConfig() {
    }

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON_SPEC = (ForgeConfigSpec)serverPair.getRight();
        COMMON = (Common)serverPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue usePaleElementGauge;
        public final ForgeConfigSpec.IntValue shrineRangeDisplayDuration;
        public final ForgeConfigSpec.BooleanValue renderPedestalShadow;
        public final ForgeConfigSpec.BooleanValue fastParticleEffects;
        public final ForgeConfigSpec.IntValue gaugeOffsetX;
        public final ForgeConfigSpec.IntValue gaugeOffsetY;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("ElementalCraft client config").push("elementalcraft-client");
            this.shrineRangeDisplayDuration = builder.comment("The duration of shrine range display.").defineInRange("shrineRangeDisplayDuration", 600, 0, 10000);
            this.renderPedestalShadow = builder.comment("Display a shadow where pedestals can be placed.").define("renderPedestalShadow", true);
            this.fastParticleEffects = builder.comment("Set to true if you want to reduce quality of particles for beter performances.").define("fastParticleEffects", false);
            builder.push("gauge");
            this.usePaleElementGauge = builder.comment("Use pale element gauges.").define("usePaleElementGauge", false);
            this.gaugeOffsetX = builder.comment("the offset of the gauge on the X axis.").defineInRange("gaugeOffsetX", 0, -10000, 10000);
            this.gaugeOffsetY = builder.comment("the offset of the gauge on the Y axis.").defineInRange("gaugeOffsetY", 0, -10000, 10000);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue shrinesCapacity;
        public final ForgeConfigSpec.IntValue firePylonRange;
        public final ForgeConfigSpec.IntValue firePylonConsumeAmount;
        public final ForgeConfigSpec.DoubleValue firePylonDamage;
        public final ForgeConfigSpec.IntValue vacuumShrineRange;
        public final ForgeConfigSpec.IntValue vacuumShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue vacuumShrinePullSpeed;
        public final ForgeConfigSpec.IntValue growthShrineRange;
        public final ForgeConfigSpec.IntValue growthShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue growthShrinePeriode;
        public final ForgeConfigSpec.IntValue harvestShrineRange;
        public final ForgeConfigSpec.IntValue harvestShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue harvestShrinePeriode;
        public final ForgeConfigSpec.IntValue lavaShrineRange;
        public final ForgeConfigSpec.IntValue lavaShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue lavaShrinePeriode;
        public final ForgeConfigSpec.IntValue oreShrineRange;
        public final ForgeConfigSpec.IntValue oreShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue oreShrinePeriode;
        public final ForgeConfigSpec.IntValue overloadShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue overloadShrinePeriode;
        public final ForgeConfigSpec.IntValue sweetShrineRange;
        public final ForgeConfigSpec.IntValue sweetShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue sweetShrinePeriode;
        public final ForgeConfigSpec.IntValue sweetShrineFood;
        public final ForgeConfigSpec.DoubleValue sweetShrineSaturation;
        public final ForgeConfigSpec.IntValue enderLockShrineRange;
        public final ForgeConfigSpec.IntValue enderLockShrineConsumeAmount;
        public final ForgeConfigSpec.IntValue breedingShrineRange;
        public final ForgeConfigSpec.IntValue breedingShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue breedingShrinePeriode;
        public final ForgeConfigSpec.IntValue groveShrineRange;
        public final ForgeConfigSpec.IntValue groveShrineConsumeAmount;
        public final ForgeConfigSpec.DoubleValue groveShrinePeriode;
        public final ForgeConfigSpec.IntValue tankCapacity;
        public final ForgeConfigSpec.IntValue tankSmallCapacity;
        public final ForgeConfigSpec.IntValue reservoirCapacity;
        public final ForgeConfigSpec.IntValue extractorExtractionAmount;
        public final ForgeConfigSpec.IntValue extractorMaxRunes;
        public final ForgeConfigSpec.IntValue improvedExtractorExtractionAmount;
        public final ForgeConfigSpec.IntValue improvedExtractorMaxRunes;
        public final ForgeConfigSpec.IntValue evaporatorExtractionAmount;
        public final ForgeConfigSpec.IntValue evaporatorMaxRunes;
        public final ForgeConfigSpec.IntValue fireFurnaceTransferSpeed;
        public final ForgeConfigSpec.IntValue fireFurnaceMaxRunes;
        public final ForgeConfigSpec.IntValue fireFurnaceElementAmount;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceTransferSpeed;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceMaxRunes;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceElementAmount;
        public final ForgeConfigSpec.IntValue infuserTransferSpeed;
        public final ForgeConfigSpec.IntValue infuserMaxRunes;
        public final ForgeConfigSpec.IntValue binderTransferSpeed;
        public final ForgeConfigSpec.IntValue binderMaxRunes;
        public final ForgeConfigSpec.IntValue improvedBinderTransferSpeed;
        public final ForgeConfigSpec.IntValue improvedBinderMaxRunes;
        public final ForgeConfigSpec.BooleanValue binderRecipeMatchOrder;
        public final ForgeConfigSpec.IntValue crystallizerTransferSpeed;
        public final ForgeConfigSpec.IntValue crystallizerMaxRunes;
        public final ForgeConfigSpec.DoubleValue crystallizerLuckRatio;
        public final ForgeConfigSpec.IntValue inscriberTransferSpeed;
        public final ForgeConfigSpec.IntValue inscriberMaxRunes;
        public final ForgeConfigSpec.IntValue airMillTransferSpeed;
        public final ForgeConfigSpec.IntValue airMillMaxRunes;
        public final ForgeConfigSpec.DoubleValue airMillLuckRatio;
        public final ForgeConfigSpec.IntValue purifierTransferSpeed;
        public final ForgeConfigSpec.IntValue purifierMaxRunes;
        public final ForgeConfigSpec.IntValue purifierDuration;
        public final ForgeConfigSpec.DoubleValue purifierLuckRatio;
        public final ForgeConfigSpec.IntValue purifierBaseCost;
        public final ForgeConfigSpec.IntValue pureOreMultiplier;
        public final ForgeConfigSpec.BooleanValue pureOreRecipeInjection;
        public final ForgeConfigSpec.BooleanValue pureOreSmeltingRecipe;
        public final ForgeConfigSpec.BooleanValue pureOreBlastingRecipe;
        public final ForgeConfigSpec.BooleanValue pureOreCampFireRecipe;
        public final ForgeConfigSpec.IntValue impairedPipeTransferAmount;
        public final ForgeConfigSpec.IntValue pipeTransferAmount;
        public final ForgeConfigSpec.IntValue improvedPipeTransferAmount;
        public final ForgeConfigSpec.IntValue sorterCooldown;
        public final ForgeConfigSpec.IntValue sorterMaxItem;
        public final ForgeConfigSpec.IntValue pureInfuserTransferSpeed;
        public final ForgeConfigSpec.IntValue pureInfuserMaxRunes;
        public final ForgeConfigSpec.IntValue pedestalCapacity;
        public final ForgeConfigSpec.IntValue pedestalMaxRunes;
        public final ForgeConfigSpec.IntValue receptacleDurability;
        public final ForgeConfigSpec.IntValue improvedReceptacleDurability;
        public final ForgeConfigSpec.BooleanValue receptacleEnchantable;
        public final ForgeConfigSpec.IntValue elementHolderCapacity;
        public final ForgeConfigSpec.IntValue elementHolderTransferAmount;
        public final ForgeConfigSpec.IntValue focusMaxSpell;
        public final ForgeConfigSpec.IntValue spellBookMaxSpell;
        public final ForgeConfigSpec.BooleanValue playersSpawnWithBook;
        public final ForgeConfigSpec.IntValue shardElementAmount;
        public final ForgeConfigSpec.IntValue chiselDurability;
        public final ForgeConfigSpec.IntValue lenseElementMultiplier;
        public final ForgeConfigSpec.BooleanValue disableWorldGen;
        public final ForgeConfigSpec.BooleanValue disableInertCrystal;
        public final ForgeConfigSpec.IntValue inertCrystalCount;
        public final ForgeConfigSpec.IntValue inertCrystalSize;
        public final ForgeConfigSpec.IntValue inertCrystalYMax;
        public final ForgeConfigSpec.IntValue sourceSpawnChance;
        public final ForgeConfigSpec.IntValue oceanSourceSpawnChance;
        public final ForgeConfigSpec.IntValue randomSourceSpawnChance;
        public final ForgeConfigSpec.IntValue sourceAltarDistance;
        public final ForgeConfigSpec.BooleanValue disableSourceExhaustion;
        public final ForgeConfigSpec.IntValue sourceCapacityMin;
        public final ForgeConfigSpec.IntValue sourceCapacityMax;
        public final ForgeConfigSpec.IntValue sourceRecoverRate;
        public final ForgeConfigSpec.BooleanValue mekanismInteracionEnabled;
        public final ForgeConfigSpec.DoubleValue mekanismPureOreDimishingAmount;
        public final ForgeConfigSpec.BooleanValue mekanismPureOreDissolutionRecipe;
        public final ForgeConfigSpec.BooleanValue mekanismPureOreInjectingRecipe;
        public final ForgeConfigSpec.BooleanValue mekanismPureOrePurifyingRecipe;
        public final ForgeConfigSpec.BooleanValue mekanismPureOreEnrichingRecipe;
        public final ForgeConfigSpec.BooleanValue mekanismPureOreCrushingRecipe;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("ElementalCraft config").push("elementalcraft");
            builder.pop().comment("Shrines config").push("shrines");
            this.shrinesCapacity = builder.comment("The element capacity of shrines.").defineInRange("shrinesCapacity", 10000, 0, 100000000);
            builder.push("firePylon");
            this.firePylonRange = builder.comment("The range of the Fire Pylon.").defineInRange("firePylonRange", 10, 0, 100);
            this.firePylonConsumeAmount = builder.comment("The amount of element consumed by the Fire Pylon.").defineInRange("firePylonConsumeAmount", 5, 0, 100);
            this.firePylonDamage = builder.comment("The damage of the Fire Pylon.").defineInRange("firePylonDamage", 2.0, 0.0, 20.0);
            builder.pop().push("vacuumShrine");
            this.vacuumShrineRange = builder.comment("The range of the Vacuum Shrine.").defineInRange("vacuumShrineRange", 10, 0, 100);
            this.vacuumShrineConsumeAmount = builder.comment("The amount of element consumed by the Vacuum Shrine.").defineInRange("vacuumShrineConsumeAmount", 1, 0, 100);
            this.vacuumShrinePullSpeed = builder.comment("The pull speed of the Vacuum Shrine.").defineInRange("vacuumShrinePullSpeed", 0.1, 0.0, 5.0);
            builder.pop().push("growthShrine");
            this.growthShrineRange = builder.comment("The range of the Growth Shrine.").defineInRange("growthShrineRange", 4, 0, 100);
            this.growthShrineConsumeAmount = builder.comment("The amount of element consumed by the Growth Shrine.").defineInRange("growthShrineConsumeAmount", 50, 0, 1000);
            this.growthShrinePeriode = builder.comment("The nember of tick betwenn two GFrowth Shrine activations.").defineInRange("growthShrinePeriode", 20.0, 0.0, 2400.0);
            builder.pop().push("harvestShrine");
            this.harvestShrineRange = builder.comment("The range of the Harvest Shrine.").defineInRange("harvestShrineRange", 4, 0, 100);
            this.harvestShrineConsumeAmount = builder.comment("The amount of element consumed by the Harvest Shrine.").defineInRange("harvestShrineConsumeAmount", 100, 0, 1000);
            this.harvestShrinePeriode = builder.comment("The nember of tick betwenn two Harvest Shrine activations.").defineInRange("harvestShrinePeriode", 20.0, 0.0, 2400.0);
            builder.pop().push("lavaShrine");
            this.lavaShrineRange = builder.comment("The range of the Lava Shrine.").defineInRange("lavaShrineRange", 1, 0, 100);
            this.lavaShrineConsumeAmount = builder.comment("The amount of element consumed by the Lava Shrine.").defineInRange("lavaShrineConsumeAmount", 5000, 0, 100000);
            this.lavaShrinePeriode = builder.comment("The nember of tick betwenn two Lava Shrine activations.").defineInRange("lavaShrinePeriode", 1200.0, 0.0, 4800.0);
            builder.pop().push("oreShrine");
            this.oreShrineRange = builder.comment("The range of the Ore Shrine.").defineInRange("oreShrineRange", 12, 0, 100);
            this.oreShrineConsumeAmount = builder.comment("The amount of element consumed by the Ore Shrine.").defineInRange("oreShrineConsumeAmount", 2000, 0, 10000);
            this.oreShrinePeriode = builder.comment("The nember of tick betwenn two Ore Shrine activations.").defineInRange("oreShrinePeriode", 200.0, 0.0, 2400.0);
            builder.pop().push("overloadShrine");
            this.overloadShrineConsumeAmount = builder.comment("The amount of element consumed by the overload Shrine.").defineInRange("overloadShrineConsumeAmount", 100, 0, 1000);
            this.overloadShrinePeriode = builder.comment("The nember of tick betwenn two Overload Shrine activations.").defineInRange("overloadShrinePeriode", 3.0, 0.0, 2400.0);
            builder.pop().push("sweetShrine");
            this.sweetShrineRange = builder.comment("The range of the Sweet Shrine.").defineInRange("sweetShrineRange", 10, 0, 100);
            this.sweetShrineConsumeAmount = builder.comment("The amount of element consumed by the Sweet Shrine.").defineInRange("sweetShrineConsumeAmount", 500, 0, 10000);
            this.sweetShrinePeriode = builder.comment("The nember of tick betwenn two Sweet Shrine activations.").defineInRange("sweetShrinePeriode", 40.0, 0.0, 2400.0);
            this.sweetShrineFood = builder.comment("The food given by the sheet shrine.").defineInRange("sweetShrineFood", 1, 1, 10);
            this.sweetShrineSaturation = builder.comment("The saturation given by the sheet shrine.").defineInRange("sweetShrineSaturation", 0.1, 0.0, 10.0);
            builder.pop().push("enderLock");
            this.enderLockShrineRange = builder.comment("The range of the Ender Lock Shrine.").defineInRange("enderLockShrineRange", 10, 0, 100);
            this.enderLockShrineConsumeAmount = builder.comment("The amount of element consumed by the Ender Lock Shrine.").defineInRange("enderLockShrineConsumeAmount", 500, 0, 10000);
            builder.pop().push("breedingShrine");
            this.breedingShrineRange = builder.comment("The range of the breeding Shrine.").defineInRange("breedingShrineRange", 10, 0, 100);
            this.breedingShrineConsumeAmount = builder.comment("The amount of element consumed by the breeding Shrine.").defineInRange("breedingShrineConsumeAmount", 2000, 0, 10000);
            this.breedingShrinePeriode = builder.comment("The nember of tick betwenn two breeding Shrine activations.").defineInRange("breedingShrinePeriode", 200.0, 0.0, 2400.0);
            builder.pop().push("groveShrine");
            this.groveShrineRange = builder.comment("The range of the wild grove Shrine.").defineInRange("groveShrineRange", 5, 0, 100);
            this.groveShrineConsumeAmount = builder.comment("The amount of element consumed by the wild grove Shrine.").defineInRange("groveShrineConsumeAmount", 500, 0, 10000);
            this.groveShrinePeriode = builder.comment("The nember of tick betwenn two wild grove Shrine activations.").defineInRange("groveShrinePeriode", 200.0, 0.0, 2400.0);
            builder.pop(2).comment("Instruments config").push("instruments").push("tank");
            this.tankSmallCapacity = builder.comment("The element capacity of a small element container.").defineInRange("tankSmallCapacity", 1000, 0, 100000000);
            this.tankCapacity = builder.comment("The element capacity of a element container.").defineInRange("tankCapacity", 100000, 0, 100000000);
            this.reservoirCapacity = builder.comment("The element capacity of a element reservoir.").defineInRange("reservoirCapacity", 5000000, 0, 100000000);
            builder.pop().push("extractor");
            this.extractorExtractionAmount = builder.comment("The amount of element extracted by an extractor.").defineInRange("extractorExtractionAmount", 5, 0, 100);
            this.extractorMaxRunes = builder.comment("The max amount of on an extractor.").defineInRange("extractorMaxRunes", 1, 0, 10);
            this.improvedExtractorExtractionAmount = builder.comment("The amount of element extracted by an improved extractor.").defineInRange("improvedExtractorExtractionAmount", 25, 0, 500);
            this.improvedExtractorMaxRunes = builder.comment("The max amount of on an improved extracto.").defineInRange("improvedExtractoMaxRunes", 3, 0, 10);
            builder.pop().push("evaporator");
            this.evaporatorExtractionAmount = builder.comment("The amount of element extracted by an evaporator.").defineInRange("evaporatorExtractionAmount", 1, 0, 100);
            this.evaporatorMaxRunes = builder.comment("The max amount of on an evaporator.").defineInRange("evaporatorMaxRunes", 1, 0, 10);
            builder.pop().push("fireFurnace");
            this.fireFurnaceTransferSpeed = builder.comment("The max amount of element consumed by the fire furnace per tick.").defineInRange("fireFurnaceTransferSpeed", 20, 0, 1000);
            this.fireFurnaceMaxRunes = builder.comment("The max amount of on a fire furnace.").defineInRange("fireFurnaceMaxRunes", 1, 0, 10);
            this.fireFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the furnace recipe.").defineInRange("fireFurnaceElementAmount", 10, 0, 1000);
            builder.push("fireBlastFurnace");
            this.fireBlastFurnaceTransferSpeed = builder.comment("The max amount of element consumed by the fire blast furnace per tick.").defineInRange("fireBlastFurnaceTransferSpeed", 40, 0, 1000);
            this.fireBlastFurnaceMaxRunes = builder.comment("The max amount of on a fire blast furnace.").defineInRange("fireBlastFurnaceMaxRunes", 2, 0, 10);
            this.fireBlastFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the blast furnace recipe.").defineInRange("fireBlastFurnaceElementAmount", 20, 0, 1000);
            builder.pop(2).push("infuser");
            this.infuserTransferSpeed = builder.comment("The max amount of element consumed by the infuser per tick.").defineInRange("infuserTransferSpeed", 10, 0, 1000);
            this.infuserMaxRunes = builder.comment("The max amount of on an infuser.").defineInRange("infuserMaxRunes", 1, 0, 10);
            builder.pop().push("binder");
            this.binderTransferSpeed = builder.comment("The max amount of element consumed by the binder per tick.").defineInRange("binderTransferSpeed", 25, 0, 1000);
            this.binderMaxRunes = builder.comment("The max amount of on an binder.").defineInRange("binderMaxRunes", 2, 0, 10);
            this.binderRecipeMatchOrder = builder.comment("Define if or not binder recip require to be ordered.").define("binderRecipeMatchOrder", true);
            builder.push("improved");
            this.improvedBinderTransferSpeed = builder.comment("The max amount of element consumed by the improved binder per tick.").defineInRange("improvedBinderTransferSpeed", 50, 0, 1000);
            this.improvedBinderMaxRunes = builder.comment("The max amount of on an improved binder.").defineInRange("improvedBinderMaxRunes", 3, 0, 10);
            builder.pop(2).push("crystallizer");
            this.crystallizerTransferSpeed = builder.comment("The max amount of element consumed by the gem crystallizer per tick.").defineInRange("crystallizerTransferSpeed", 25, 0, 1000);
            this.crystallizerMaxRunes = builder.comment("The max amount of on an crystallizer.").defineInRange("crystallizerMaxRunes", 3, 0, 10);
            this.crystallizerLuckRatio = builder.comment("The ratio of each luck rune on a crystallizer.").defineInRange("crystallizerLuckRatio", 3.0, 0.0, 10.0);
            builder.pop().push("inscriber");
            this.inscriberTransferSpeed = builder.comment("The max amount of element consumed by the gem inscriber per tick.").defineInRange("inscriberTransferSpeed", 1000, 0, 10000);
            this.inscriberMaxRunes = builder.comment("The max amount of on an inscriber.").defineInRange("inscriberMaxRunes", 3, 0, 10);
            builder.pop().push("airMill");
            this.airMillTransferSpeed = builder.comment("The max amount of element consumed by the Air Mill Grindstone per tick.").defineInRange("airMillTransferSpeed", 10, 0, 1000);
            this.airMillMaxRunes = builder.comment("The max amount of on an Air Mill Grindstone.").defineInRange("airMillMaxRunes", 3, 0, 10);
            this.airMillLuckRatio = builder.comment("The ratio of each luck rune on a Air Mill Grindstone.").defineInRange("airMillLuckRatio", 2.0, 0.0, 10.0);
            builder.pop().push("purifier");
            this.purifierTransferSpeed = builder.comment("The max amount of element consumed by the Ore Purifier per tick.").defineInRange("purifierTransferSpeed", 25, 0, 1000);
            this.purifierMaxRunes = builder.comment("The max amount of on an purifier.").defineInRange("purifierMaxRunes", 3, 0, 10);
            this.purifierDuration = builder.comment("The nember of tick for a Ore Purifier to procces one item.").defineInRange("purifierDuration", 100, 0, 2400);
            this.purifierLuckRatio = builder.comment("The ratio of each luck rune on a purifier.").defineInRange("purifierLuckRatio", 3.0, 0.0, 10.0);
            this.purifierBaseCost = builder.comment("The base cost of a piurifier recipe.").defineInRange("purifierBaseCost", 2500, 0, 10000);
            builder.push("pureOre");
            this.pureOreMultiplier = builder.comment("The number of output pure ores by a purifier.").defineInRange("pureOreMultiplier", 2, 1, 20);
            this.pureOreRecipeInjection = builder.comment("Set to false if you want to manualy manage processing of pure ore.").define("pureOreRecipeInjection", true);
            this.pureOreSmeltingRecipe = builder.comment("Set to false if you want pure ore to not use smelting recipes.").define("pureOreSmeltingRecipe", true);
            this.pureOreBlastingRecipe = builder.comment("Set to false if you want pure ore to not use blasting recipes.").define("pureOreBlastingRecipe", true);
            this.pureOreCampFireRecipe = builder.comment("Set to false if you want pure ore to not use camp fire recipes.").define("pureOreCampFireRecipe", true);
            builder.pop(2).push("elementPipe");
            this.impairedPipeTransferAmount = builder.comment("The amount of element transferred by impaired pipes.").defineInRange("impairedPipeTransferAmount", 5, 0, 10000);
            this.pipeTransferAmount = builder.comment("The amount of element transferred by pipes.").defineInRange("pipeTransferAmount", 25, 0, 10000);
            this.improvedPipeTransferAmount = builder.comment("The amount of element transferred by improved pipes.").defineInRange("improvedPipeTransferAmount", 100, 0, 10000);
            builder.pop().push("sorter");
            this.sorterCooldown = builder.comment("The amount of tick between two ordered sorter item transpher.").defineInRange("sorterCooldown", 10, 0, 100);
            this.sorterMaxItem = builder.comment("The max amount of items an order sorter can filter.").defineInRange("sorterMaxItem", 15, 0, 100);
            builder.pop(2).comment("Pure Infusser and pedestals config").push("pureInfuser");
            this.pureInfuserTransferSpeed = builder.comment("The max amount of element consumed by the pure infuser per tick.").defineInRange("pureInfuserTransferSpeed", 100, 0, 1000);
            this.pureInfuserMaxRunes = builder.comment("The max amount of on a pure infuser.").defineInRange("pureInfuserMaxRunes", 3, 0, 10);
            builder.push("pedestals");
            this.pedestalMaxRunes = builder.comment("The max amount of on a pedestal.").defineInRange("pedestalMaxRunes", 1, 0, 10);
            this.pedestalCapacity = builder.comment("The element capacity of a pedestal.").defineInRange("pedestalCapacity", 10000, 0, 100000000);
            builder.pop(2).comment("Items config").push("items");
            this.receptacleDurability = builder.comment("Define source receptacle durablility (0 for unbreakable).").defineInRange("receptacleDurability", 5, 0, 1000);
            this.improvedReceptacleDurability = builder.comment("Define improved source receptacle durablility (0 for unbreakable).").defineInRange("improvedReceptacleDurability", 20, 0, 1000);
            this.receptacleEnchantable = builder.comment("Define if or not receptacles can be enchanted.").define("receptacleEnchantable", false);
            this.elementHolderCapacity = builder.comment("The element capacity of an element holder.").defineInRange("elementHolderCapacity", 10000, 0, 100000000);
            this.elementHolderTransferAmount = builder.comment("The amount of element transfered by an element holder.").defineInRange("elementHolderTransferAmount", 25, 0, 1000);
            this.focusMaxSpell = builder.comment("The max number of spells on a focus.").defineInRange("focusMaxSpell", 10, 1, 20);
            this.spellBookMaxSpell = builder.comment("The max number of spells on an elementalist grimoire.").defineInRange("spellBookMaxSpell", 100, 1, 1000);
            this.playersSpawnWithBook = builder.comment("Players start the game with an elementopedia in their inventory.").define("playersSpawnWithBook", false);
            this.shardElementAmount = builder.comment("The amount of element contained in a single shard.").defineInRange("shardElementAmount", 250, 0, 1000);
            this.chiselDurability = builder.comment("Define chisel durablility (0 for unbreakable).").defineInRange("chiselDurability", 250, 0, 1000);
            this.lenseElementMultiplier = builder.comment("the multiplier of lense (based on 1000)").defineInRange("lenseElementMultiplier", 100, 0, 100);
            builder.pop().comment("Worldgen config").push("worldgen");
            this.disableWorldGen = builder.comment("Disable all elementalcraft world gen.").define("disableWorldGen", false);
            builder.push("inertCrystal");
            this.disableInertCrystal = builder.comment("Disable creation of inertCrystals.").define("disableInertCrystal", false);
            this.inertCrystalCount = builder.comment("Number of inert crystal vein.").defineInRange("inertCrystalCount", 10, 1, 100);
            this.inertCrystalSize = builder.comment("Size of inert crystal vein.").defineInRange("inertCrystalSize", 9, 1, 100);
            this.inertCrystalYMax = builder.comment("max Y level of inert crystal.").defineInRange("inertCrystalYMax", 64, 1, 256);
            builder.pop();
            this.sourceSpawnChance = builder.comment("Chance to add a source in world (the small the more frequante).").defineInRange("sourceSpawnChance", 30, 1, 10000);
            this.oceanSourceSpawnChance = builder.comment("Chance to add a source in an ocean biome (the small the more frequante).").defineInRange("oceanSourceSpawnChance", 150, 1, 10000);
            this.randomSourceSpawnChance = builder.comment("Chance to add a source in world ingoring biome elemen type (the small the more frequante).").defineInRange("randomSourceSpawnChance", 300, 1, 10000);
            this.sourceAltarDistance = builder.comment("CSource Altar genreration distance setting.").defineInRange("sourceAltarDistance", 64, 0, 100);
            builder.pop().comment("Source config").push("source");
            this.disableSourceExhaustion = builder.comment("set to true to make sources infinite.").define("disableSourceExhaustion", false);
            this.sourceCapacityMin = builder.comment("The minimum element capacity of a source.").defineInRange("sourceCapacityMin", 500000, 0, 10000000);
            this.sourceCapacityMax = builder.comment("The maximum element capacity of a source.").defineInRange("sourceCapacityMax", 1000000, 0, 10000000);
            this.sourceRecoverRate = builder.comment("The element a source can generate per tick.").defineInRange("sourceRecoverRate", 5, 0, 100);
            builder.pop().comment("mod interaction config").push("interaction").push("mekanism");
            this.mekanismInteracionEnabled = builder.comment("Enable interaction with mekanism.").define("mekanismInteracionEnabled", true);
            this.mekanismPureOreDimishingAmount = builder.comment("The dimishing amount multiplier when using pure ore in mekanism. it prevent an exploit.").defineInRange("mekanismPureOreDimishingAmount", 0.75, 0.0, 1.0);
            this.mekanismPureOreDissolutionRecipe = builder.comment("Set to false if you want pure ore to not use mekanism dissolution recipes.").define("mekanismPureOreDissolutionRecipe", true);
            this.mekanismPureOreInjectingRecipe = builder.comment("Set to false if you want pure ore to not use mekanism injecting recipes.").define("mekanismPureOreInjectingRecipe", true);
            this.mekanismPureOrePurifyingRecipe = builder.comment("Set to false if you want pure ore to not use mekanism purifying recipes.").define("mekanismPureOrePurifyingRecipe", true);
            this.mekanismPureOreEnrichingRecipe = builder.comment("Set to false if you want pure ore to not use mekanism enriching recipes.").define("mekanismPureOreEnrichingRecipe", true);
            this.mekanismPureOreCrushingRecipe = builder.comment("Set to false if you want pure ore to not use mekanism crushing recipes.").define("mekanismPureOreCrushingRecipe", true);
            builder.pop(2);
        }
    }
}

