/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.data.predicate.block.rune.IRunePredicate;
import sirttas.elementalcraft.rune.Rune;
import sirttas.elementalcraft.rune.handler.IRuneHandler;
import sirttas.elementalcraft.tag.ECTags;

public class TagHasRunePredicate
implements IRunePredicate {
    public static final String NAME = "tag_has_rune";
    @ObjectHolder(value="elementalcraft:tag_has_rune")
    public static final BlockPosPredicateType<TagHasRunePredicate> TYPE = null;
    public static final Codec<TagHasRunePredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.field_240908_a_.fieldOf("tag").forGetter(p -> p.tagId), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, TagHasRunePredicate::new));
    private final int count;
    private final ResourceLocation tagId;
    private ITag<Rune> tag;

    public TagHasRunePredicate(ITag.INamedTag<Rune> tag) {
        this(tag, 1);
    }

    public TagHasRunePredicate(ITag.INamedTag<Rune> tag, int count) {
        this(tag.func_230234_a_(), count);
        this.tag = tag;
    }

    public TagHasRunePredicate(ResourceLocation runeId) {
        this(runeId, 1);
    }

    public TagHasRunePredicate(ResourceLocation runeId, int count) {
        this.tagId = runeId;
        this.count = count;
    }

    @Override
    public boolean test(IRuneHandler handler) {
        if (this.tag == null) {
            this.tag = ECTags.Runes.RUNE_TAGS.getTag(this.tagId);
        }
        return this.tag.func_230236_b_().stream().mapToInt(handler::getRuneCount).sum() >= this.count;
    }

    public BlockPosPredicateType<TagHasRunePredicate> getType() {
        return TYPE;
    }
}

