/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.elemental.ItemElementHolder;

public class ECItemModelProvider
extends ItemModelProvider {
    public ECItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "elementalcraft", existingFileHelper);
    }

    protected void registerModels() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!"elementalcraft".equals(item.getRegistryName().func_110624_b()) || this.exists(item)) continue;
            String name = item.getRegistryName().func_110623_a();
            if (item instanceof BlockItem) {
                this.withExistingParent(name, ElementalCraft.createRL("block/" + name));
                continue;
            }
            if (item instanceof ItemElementHolder) {
                this.withExistingParent(name, ElementalCraft.createRL("item/template_element_holder"));
                continue;
            }
            this.singleTexture(name);
        }
    }

    public ItemModelBuilder singleTexture(String name) {
        return this.singleTexture(name, ElementalCraft.createRL("item/" + name));
    }

    public ItemModelBuilder singleTexture(String name, ResourceLocation texture) {
        return (ItemModelBuilder)this.singleTexture(name, new ResourceLocation("minecraft", "item/generated"), "layer0", texture);
    }

    public ItemModelBuilder runeTexture(String name, ResourceLocation slate, ResourceLocation rune) {
        return (ItemModelBuilder)this.singleTexture(name, slate).texture("layer1", rune);
    }

    private boolean exists(Item item) {
        return this.existingFileHelper.exists(item.getRegistryName(), ResourcePackType.CLIENT_RESOURCES, ".json", "models/item");
    }

    @Nonnull
    public String func_200397_b() {
        return "ElementalCraft item models";
    }

    public void clear() {
        super.clear();
    }

    public void generateAll(DirectoryCache cache) {
        super.generateAll(cache);
    }
}

