/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.loot;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.datagen.loot.AbstractECLootProvider;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.loot.function.ECLootFunctions;
import sirttas.elementalcraft.loot.function.RandomSpell;

public class ECChestLootProvider
extends AbstractECLootProvider {
    public ECChestLootProvider(DataGenerator generator) {
        super(generator);
        ECLootFunctions.setup();
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.save(cache, ECChestLootProvider.genInject(), ElementalCraft.createRL("inject"));
        this.save(cache, ECChestLootProvider.genSmallAltar(ElementType.FIRE), ElementalCraft.createRL("altar/small_fire"));
        this.save(cache, ECChestLootProvider.genMediumAltar(ElementType.FIRE), ElementalCraft.createRL("altar/medium_fire"));
        this.save(cache, ECChestLootProvider.genSmallAltar(ElementType.WATER), ElementalCraft.createRL("altar/small_water"));
        this.save(cache, ECChestLootProvider.genMediumAltar(ElementType.WATER), ElementalCraft.createRL("altar/medium_water"));
        this.save(cache, ECChestLootProvider.genSmallAltar(ElementType.AIR), ElementalCraft.createRL("altar/small_air"));
        this.save(cache, ECChestLootProvider.genMediumAltar(ElementType.AIR), ElementalCraft.createRL("altar/medium_air"));
        this.save(cache, ECChestLootProvider.genSmallAltar(ElementType.EARTH), ElementalCraft.createRL("altar/small_earth"));
        this.save(cache, ECChestLootProvider.genMediumAltar(ElementType.EARTH), ElementalCraft.createRL("altar/medium_earth"));
    }

    private static LootPool.Builder genInject() {
        return ECChestLootProvider.genBase((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.INERT_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f))).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.FIRE_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.EARTH_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.WATER_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.AIR_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.FIRE_SHARD).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.WATER_SHARD).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.EARTH_SHARD).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.AIR_SHARD).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.POWERFUL_FIRE_SHARD).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.POWERFUL_WATER_SHARD).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.POWERFUL_EARTH_SHARD).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.POWERFUL_AIR_SHARD).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SCROLL).func_212841_b_(RandomSpell.builder()).func_216086_a(15));
    }

    private static LootTable.Builder genSmallAltar(ElementType type) {
        return ECChestLootProvider.genWithType((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f), type);
    }

    private static LootTable.Builder genMediumAltar(ElementType type) {
        return ECChestLootProvider.addAdvanced(ECChestLootProvider.genWithType((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f), type), (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f), type);
    }

    private static LootPool.Builder genBase(IRandomRange range) {
        return LootPool.func_216096_a().name("main").func_216046_a(range).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.DRENCHED_IRON_INGOT).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.DRENCHED_IRON_NUGGET).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SWIFT_ALLOY_INGOT).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SWIFT_ALLOY_NUGGET).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))).func_216086_a(7)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SCROLL_PAPER).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))).func_216086_a(8));
    }

    private static LootTable.Builder genWithType(IRandomRange range, ElementType type) {
        return ECChestLootProvider.addVanilla(LootTable.func_216119_b().func_216040_a(ECChestLootProvider.genBase(range).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.INERT_CRYSTAL).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECChestLootProvider.getCrystalForType(type)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)6.0f))).func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECChestLootProvider.getShardForType(type)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)10.0f))).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECChestLootProvider.getPowerfulShardForType(type)).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SCROLL).func_212841_b_(RandomSpell.builder(type)).func_216086_a(15))));
    }

    private static LootTable.Builder addAdvanced(LootTable.Builder builder, IRandomRange range, ElementType type) {
        return builder.func_216040_a(LootPool.func_216096_a().name("advanced").func_216046_a(range).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SWIFT_ALLOY_INGOT).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SWIFT_ALLOY_NUGGET).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f))).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.SCROLL).func_212841_b_(RandomSpell.builder(type)).func_216086_a(15)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.PURE_CRYSTAL).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ECItems.EMPTY_RECEPTACLE).func_216086_a(2)));
    }

    private static LootTable.Builder addVanilla(LootTable.Builder builder) {
        return builder.func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)).name("vanilla_1").func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151025_P).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151015_O).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151133_ar).func_216086_a(10)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151081_bc).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151080_bb).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_185163_cU).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).name("vanilla_2").func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151103_aS).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)8.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151016_H).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)8.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151078_bh).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)8.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151007_F).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)8.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151079_bi).func_216086_a(2)));
    }

    private void save(DirectoryCache cache, LootPool.Builder pool, ResourceLocation location) throws IOException {
        this.save(cache, LootTable.func_216119_b().func_216040_a(pool), location);
    }

    private void save(DirectoryCache cache, LootTable.Builder builder, ResourceLocation location) throws IOException {
        this.save(cache, builder.func_216039_a(LootParameterSets.field_216261_b), this.getPath(location));
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/loot_tables/chests/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ElementalCraft inject loot tables";
    }
}

