/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.managed;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.data.predicate.block.rune.TagHasRunePredicate;
import sirttas.elementalcraft.datagen.ECItemModelProvider;
import sirttas.elementalcraft.rune.Rune;
import sirttas.elementalcraft.tag.ECTags;

public class RunesProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private ECItemModelProvider itemModelProvider;
    private static final IBlockPosPredicate LUCK_PREDICATE = IBlockPosPredicate.match(ECTags.Blocks.RUNE_AFFECTED_LUCK).and(new IBlockPosPredicate[]{new TagHasRunePredicate(ECTags.Runes.LUCK_RUNES).not()});
    public static final ResourceLocation MINOR_SLATE = ElementalCraft.createRL("item/minor_rune_slate");
    public static final ResourceLocation SLATE = ElementalCraft.createRL("item/rune_slate");
    public static final ResourceLocation MAJOR_SLATE = ElementalCraft.createRL("item/major_rune_slate");

    public RunesProvider(DataGenerator generatorIn, ECItemModelProvider itemModelProvider) {
        this.generator = generatorIn;
        this.itemModelProvider = itemModelProvider;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.itemModelProvider.clear();
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_SPEED).addBonus(Rune.BonusType.SPEED, 0.1f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.05f), "wii", MINOR_SLATE);
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_SPEED).addBonus(Rune.BonusType.SPEED, 0.3f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.05f), "fus", SLATE);
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_SPEED).addBonus(Rune.BonusType.SPEED, 0.5f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.05f), "zod", MAJOR_SLATE);
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_PRESERVATION).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, 0.05f).addBonus(Rune.BonusType.SPEED, -0.1f), "manx", MINOR_SLATE);
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_PRESERVATION).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, 0.1f).addBonus(Rune.BonusType.SPEED, -0.1f), "jita", SLATE);
        this.addRune(cache, Rune.Builder.create().match(ECTags.Blocks.RUNE_AFFECTED_PRESERVATION).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, 0.15f).addBonus(Rune.BonusType.SPEED, -0.1f), "tano", MAJOR_SLATE);
        this.addRune(cache, Rune.Builder.create().predicate(LUCK_PREDICATE).addBonus(Rune.BonusType.LUCK, 1.0f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.1f).max(1), "claptrap", MINOR_SLATE);
        this.addRune(cache, Rune.Builder.create().predicate(LUCK_PREDICATE).addBonus(Rune.BonusType.LUCK, 2.0f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.1f).max(1), "bombadil", SLATE);
        this.addRune(cache, Rune.Builder.create().predicate(LUCK_PREDICATE).addBonus(Rune.BonusType.LUCK, 3.0f).addBonus(Rune.BonusType.ELEMENT_PRESERVATION, -0.1f).max(1), "tzeentch", MAJOR_SLATE);
        this.itemModelProvider.generateAll(cache);
    }

    private void addRune(DirectoryCache cache, Rune.Builder builder, String name, ResourceLocation slate) throws IOException {
        String path = "elementalcraft_runes/" + name;
        ResourceLocation runeTexture = ElementalCraft.createRL(path);
        this.save(cache, builder.model(this.itemModelProvider.runeTexture("item/" + path, slate, runeTexture)).sprite(runeTexture), name);
    }

    protected void save(DirectoryCache cache, Rune.Builder builder, String name) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)builder.toJson(), (Path)this.getPath(ElementalCraft.createRL(name)));
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + '/' + "elementalcraft_runes" + '/' + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ElementalCraft Spell Properties";
    }
}

