/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.managed;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.data.predicate.block.shrine.HasShrineUpgradePredicate;
import sirttas.elementalcraft.tag.ECTags;

public class ShrineUpgradeProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ShrineUpgradeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.ORE_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 2.0f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_fortune")), "shrine_upgrade_silk_touch");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.ORE_SHRINE).max(3).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 1.3f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_silk_touch")), "shrine_upgrade_fortune");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.HARVEST_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 3.0f), "shrine_upgrade_planting");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.GROWTH_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 5.0f).addBonus(ShrineUpgrade.BonusType.SPEED, 4.0f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_stem_pollination")), "shrine_upgrade_boneless_growth");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.VACUUM_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 500.0f).addBonus(ShrineUpgrade.BonusType.SPEED, 20.0f).addBonus(ShrineUpgrade.BonusType.RANGE, 0.5f), "shrine_upgrade_pickup");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.SWEET_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 5.0f).addBonus(ShrineUpgrade.BonusType.SPEED, 2.0f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_strength")), "shrine_upgrade_nectar");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.GROVE_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 2.0f).addBonus(ShrineUpgrade.BonusType.SPEED, 2.0f), "shrine_upgrade_mystical_grove");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECBlocks.GROWTH_SHRINE).max(1).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 4.0f).addBonus(ShrineUpgrade.BonusType.SPEED, 3.0f).addBonus(ShrineUpgrade.BonusType.RANGE, 0.5f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_boneless_growth")), "shrine_upgrade_stem_pollination");
        this.save(cache, ShrineUpgrade.Builder.create().predicate(IBlockPosPredicate.match(ECTags.Blocks.SHRINES_UPGRADABLES_ACCELERATION).or(new IBlockPosPredicate[]{IBlockPosPredicate.match((Block[])new Block[]{ECBlocks.VACUUM_SHRINE}).and(new IBlockPosPredicate[]{new HasShrineUpgradePredicate(ElementalCraft.createRL("shrine_upgrade_pickup"))})})).addBonus(ShrineUpgrade.BonusType.SPEED, 0.5f), "shrine_upgrade_acceleration");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECTags.Blocks.SHRINES_UPGRADABLES_RANGE).addBonus(ShrineUpgrade.BonusType.RANGE, 1.5f).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 1.2f).addBonus(ShrineUpgrade.BonusType.SPEED, 1.2f), "shrine_upgrade_range");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECTags.Blocks.SHRINES).max(1).addBonus(ShrineUpgrade.BonusType.CAPACITY, 5.0f).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 1.1f).addBonus(ShrineUpgrade.BonusType.SPEED, 1.1f), "shrine_upgrade_capacity");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECTags.Blocks.SHRINES).addBonus(ShrineUpgrade.BonusType.CAPACITY, 0.9f).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 0.5f), "shrine_upgrade_efficiency");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECTags.Blocks.SHRINES_UPGRADABLES_STRENGTH).addBonus(ShrineUpgrade.BonusType.STRENGTH, 2.0f).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 1.2f).incompatibleWith(ElementalCraft.createRL("shrine_upgrade_nectar")), "shrine_upgrade_strength");
        this.save(cache, ShrineUpgrade.Builder.create().match(ECTags.Blocks.SHRINES).max(2).addBonus(ShrineUpgrade.BonusType.CAPACITY, 1.25f).addBonus(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION, 0.75f).addBonus(ShrineUpgrade.BonusType.SPEED, 0.8f), "shrine_upgrade_optimization");
    }

    protected void save(DirectoryCache cache, ShrineUpgrade.Builder builder, String name) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)builder.toJson(), (Path)this.getPath(ElementalCraft.createRL(name)));
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/elementalcraft_shrine_upgrades/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ElementalCraft Shrines Upgrades";
    }
}

