/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.managed;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.properties.SpellProperties;

public class SpellPropertiesProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public SpellPropertiesProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.EARTH).color(175, 179, 179).consumeAmount(250).cooldown(40).weight(20), "gravelfall");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.EARTH).color(207, 212, 212).consumeAmount(500).cooldown(100).weight(20), "stonewall");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.FIRE).color(245, 174, 22).consumeAmount(500).cooldown(100).weight(30), "fireball");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.UTILITY).elementType(ElementType.AIR).color(250, 252, 222).consumeAmount(1000).cooldown(200).weight(5).range(10.0), "item_pull");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.AIR).color(103, 15, 105).consumeAmount(1000).cooldown(60).weight(15).range(20.0), "ender_strike");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.UTILITY).elementType(ElementType.WATER).color(0, 134, 161).consumeAmount(2000).cooldown(200).weight(10), "animal_growth");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.UTILITY).elementType(ElementType.EARTH).color(0, 128, 34).consumeAmount(3000).cooldown(600).weight(5).range(15.0), "tree_fall");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.MIXED).elementType(ElementType.WATER).color(5, 207, 247).consumeAmount(1000).cooldown(200).weight(10), "purification");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.UTILITY).elementType(ElementType.WATER).color(0, 189, 126).consumeAmount(200).cooldown(20).weight(20), "ripening");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.FIRE).color(156, 45, 11).consumeAmount(1000).cooldown(60).weight(15).range(3.0), "flame_cleave");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.COMBAT).elementType(ElementType.FIRE).color(255, 128, 48).consumeAmount(10).cooldown(120).weight(20).range(5.0).useDuration(200), "inferno");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.MIXED).elementType(ElementType.AIR).color(190, 206, 237).consumeAmount(400).cooldown(40).weight(5).range(6.0), "dash");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.UTILITY).elementType(ElementType.EARTH).color(4, 77, 60).consumeAmount(5000).cooldown(700).weight(2).range(15.0), "silk_vein");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.MIXED).elementType(ElementType.WATER).color(Effects.field_76432_h.func_76401_j()).consumeAmount(1000).cooldown(600).weight(5), "heal");
        this.save(cache, SpellProperties.Builder.create(Spell.Type.MIXED).elementType(ElementType.AIR).color(Effects.field_76424_c.func_76401_j()).consumeAmount(4000).cooldown(2400).weight(2), "speed");
    }

    protected void save(DirectoryCache cache, SpellProperties.Builder builder, String name) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)builder.toJson(), (Path)this.getPath(ElementalCraft.createRL(name)));
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/elementalcraft_spell_properties/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ElementalCraft Spell Properties";
    }
}

