/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.managed;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.effect.AttributeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.AutoSmeltToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.DodgeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.ElementCostReductionToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.EnchantmentToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.FastDrawToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.IToolInfusionEffect;

public class ToolInfusionProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ToolInfusionProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.save(cache, ElementType.FIRE, new EnchantmentToolInfusionEffect(Enchantments.field_77334_n));
        this.save(cache, ElementType.FIRE, new EnchantmentToolInfusionEffect(Enchantments.field_185311_w));
        this.save(cache, ElementType.FIRE, new EnchantmentToolInfusionEffect(Enchantments.field_77329_d));
        this.save(cache, ElementType.FIRE, new EnchantmentToolInfusionEffect(Enchantments.field_222194_I));
        this.save(cache, ElementType.FIRE, new EnchantmentToolInfusionEffect(Enchantments.field_203194_D));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185308_t));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185304_p));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_151370_z));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185297_d));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185298_f));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185310_v));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_222192_G));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_203193_C));
        this.save(cache, ElementType.WATER, new EnchantmentToolInfusionEffect(Enchantments.field_185300_i));
        this.save(cache, ElementType.EARTH, new EnchantmentToolInfusionEffect(Enchantments.field_185307_s));
        this.save(cache, ElementType.EARTH, new EnchantmentToolInfusionEffect(Enchantments.field_180310_c));
        this.save(cache, ElementType.EARTH, new EnchantmentToolInfusionEffect(Enchantments.field_185302_k));
        this.save(cache, ElementType.EARTH, new EnchantmentToolInfusionEffect(Enchantments.field_185309_u));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_180309_e));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_185305_q));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_222193_H));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_151369_A));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_203195_E));
        this.save(cache, ElementType.AIR, new EnchantmentToolInfusionEffect(Enchantments.field_180308_g));
        this.save(cache, ElementType.FIRE, new AutoSmeltToolInfusionEffect(), "autosmelt");
        this.save(cache, ElementType.AIR, new DodgeToolInfusionEffect(0.1), "dodge");
        this.save(cache, ElementType.AIR, new FastDrawToolInfusionEffect(3), "fastdraw");
        this.save(cache, ElementType.AIR, new AttributeToolInfusionEffect(Lists.newArrayList((Object[])new EquipmentSlotType[]{EquipmentSlotType.MAINHAND}), Attributes.field_233825_h_, new AttributeModifier("Attack Speed Infusion", 0.8, AttributeModifier.Operation.ADDITION)), "attack_speed");
        this.save(cache, ElementType.AIR, new AttributeToolInfusionEffect(Lists.newArrayList((Object[])new EquipmentSlotType[]{EquipmentSlotType.LEGS}), Attributes.field_233821_d_, new AttributeModifier("Movement Speed Infusion", 0.01, AttributeModifier.Operation.ADDITION)), "movement_speed");
        this.save(cache, new ElementCostReductionToolInfusionEffect(ElementType.FIRE, 0.1f), "fire_reduction");
        this.save(cache, new ElementCostReductionToolInfusionEffect(ElementType.WATER, 0.1f), "water_reduction");
        this.save(cache, new ElementCostReductionToolInfusionEffect(ElementType.EARTH, 0.1f), "earth_reduction");
        this.save(cache, new ElementCostReductionToolInfusionEffect(ElementType.AIR, 0.1f), "air_reduction");
    }

    protected void save(DirectoryCache cache, ElementType type, IToolInfusionEffect infusion, String name) throws IOException {
        this.save(cache, this.createToolInfusion(type, infusion), name);
    }

    private void save(DirectoryCache cache, ElementCostReductionToolInfusionEffect infusion, String name) throws IOException {
        this.save(cache, this.createToolInfusion(infusion.getElementType(), infusion), name);
    }

    protected void save(DirectoryCache cache, ElementType type, EnchantmentToolInfusionEffect infusion) throws IOException {
        this.save(cache, this.createToolInfusion(type, infusion), infusion.getEnchantment().getRegistryName().func_110623_a());
    }

    protected void save(DirectoryCache cache, ToolInfusion infusion, String name) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)CodecHelper.encode(ToolInfusion.CODEC, (Object)infusion), (Path)this.getPath(ElementalCraft.createRL(name)));
    }

    private ToolInfusion createToolInfusion(ElementType type, IToolInfusionEffect infusion) {
        return new ToolInfusion(type, Lists.newArrayList((Object[])new IToolInfusionEffect[]{infusion}));
    }

    private Path getPath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/" + "elementalcraft_tool_infusions" + "/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ElementalCraft Tool infusion";
    }
}

