/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.recipe.instrument.io.grinding.AirMillGrindingRecipe;

public class AirMillGrindingRecipeBuilder {
    private final Item result;
    private Ingredient ingredient;
    private int elementAmount;

    public AirMillGrindingRecipeBuilder(IItemProvider resultProviderIn) {
        this.result = resultProviderIn.func_199767_j();
        this.elementAmount = 1000;
    }

    public static AirMillGrindingRecipeBuilder grindingRecipe(IItemProvider resultIn) {
        return new AirMillGrindingRecipeBuilder(resultIn);
    }

    public AirMillGrindingRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    public AirMillGrindingRecipeBuilder withIngredient(ITag.INamedTag<Item> tagIn) {
        return this.withIngredient(Ingredient.func_199805_a(tagIn));
    }

    public AirMillGrindingRecipeBuilder withIngredient(IItemProvider itemIn) {
        return this.withIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public AirMillGrindingRecipeBuilder withIngredient(ItemStack stack) {
        return this.withIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
    }

    public AirMillGrindingRecipeBuilder withIngredient(Ingredient ingredientIn) {
        this.ingredient = ingredientIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        this.build(consumerIn, ElementalCraft.createRL("grinding/" + id.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Grinding Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ElementalCraft.createRL("grinding/" + save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.result, this.elementAmount));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item output;
        private final int elementAmount;

        public Result(ResourceLocation idIn, Ingredient ingredient, Item resultIn, int elementAmount) {
            this.id = idIn;
            this.ingredient = ingredient;
            this.output = resultIn;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_amount", (Number)this.elementAmount);
            json.add("input", this.ingredient.func_200304_c());
            JsonObject outputJson = new JsonObject();
            outputJson.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output).toString());
            json.add("output", (JsonElement)outputJson);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return AirMillGrindingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

