/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizationRecipeBuilder {
    private final List<CrystallizationRecipe.ResultEntry> outputs;
    private final List<Ingredient> ingredients = Lists.newArrayList((Object[])new Ingredient[]{Ingredient.field_193370_a, Ingredient.field_193370_a, Ingredient.field_193370_a});
    private final ElementType elementType;
    private int elementAmount;
    private final IRecipeSerializer<?> serializer;

    public CrystallizationRecipeBuilder(IRecipeSerializer<?> serializerIn, ElementType elementType) {
        this.serializer = serializerIn;
        this.elementType = elementType;
        this.elementAmount = 5000;
        this.outputs = Lists.newArrayList();
    }

    public static CrystallizationRecipeBuilder crystallizationRecipe(ElementType elementType) {
        return new CrystallizationRecipeBuilder(CrystallizationRecipe.SERIALIZER, elementType);
    }

    public CrystallizationRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    public CrystallizationRecipeBuilder setGem(ITag.INamedTag<Item> tagIn) {
        return this.setIngredient(0, tagIn);
    }

    public CrystallizationRecipeBuilder setGem(IItemProvider itemIn) {
        return this.setIngredient(0, itemIn);
    }

    public CrystallizationRecipeBuilder setGem(Ingredient ingredientIn) {
        return this.setIngredient(0, ingredientIn);
    }

    public CrystallizationRecipeBuilder setCrystal(ITag.INamedTag<Item> tagIn) {
        return this.setIngredient(1, tagIn);
    }

    public CrystallizationRecipeBuilder setCrystal(IItemProvider itemIn) {
        return this.setIngredient(1, itemIn);
    }

    public CrystallizationRecipeBuilder setCrystal(Ingredient ingredientIn) {
        return this.setIngredient(1, ingredientIn);
    }

    public CrystallizationRecipeBuilder setShard(ITag.INamedTag<Item> tagIn) {
        return this.setIngredient(2, tagIn);
    }

    public CrystallizationRecipeBuilder setShard(IItemProvider itemIn) {
        return this.setIngredient(2, itemIn);
    }

    public CrystallizationRecipeBuilder setShard(Ingredient ingredientIn) {
        return this.setIngredient(2, ingredientIn);
    }

    private CrystallizationRecipeBuilder setIngredient(int index, ITag.INamedTag<Item> tagIn) {
        return this.setIngredient(index, Ingredient.func_199805_a(tagIn));
    }

    private CrystallizationRecipeBuilder setIngredient(int index, IItemProvider itemIn) {
        return this.setIngredient(index, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    private CrystallizationRecipeBuilder setIngredient(int index, Ingredient ingredientIn) {
        this.ingredients.set(index, ingredientIn);
        return this;
    }

    public CrystallizationRecipeBuilder addOutput(IItemProvider item, float weight) {
        return this.addOutput(item, weight, 1.0f);
    }

    public CrystallizationRecipeBuilder addOutput(IItemProvider item, float weight, float quality) {
        this.outputs.add(CrystallizationRecipe.createResult(new ItemStack(item), weight, quality));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        this.build(consumerIn, ElementalCraft.createRL("crystallization/" + save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredients, this.outputs, this.elementType, this.elementAmount));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> ingredients;
        private final List<CrystallizationRecipe.ResultEntry> outputs;
        private final ElementType elementType;
        private final int elementAmount;
        private final IRecipeSerializer<?> serializer;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, List<Ingredient> ingredients, List<CrystallizationRecipe.ResultEntry> outputs, ElementType elementType, int elementAmount) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredients = ingredients;
            this.outputs = outputs;
            this.elementType = elementType;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_type", this.elementType.func_176610_l());
            json.addProperty("element_amount", (Number)this.elementAmount);
            JsonObject ingredientsJson = new JsonObject();
            ingredientsJson.add("gem", this.ingredients.get(0).func_200304_c());
            ingredientsJson.add("crystal", this.ingredients.get(1).func_200304_c());
            ingredientsJson.add("shard", this.ingredients.get(2).func_200304_c());
            json.add("ingredients", (JsonElement)ingredientsJson);
            json.add("outputs", CodecHelper.encode(CrystallizationRecipe.ResultEntry.LIST_CODEC, this.outputs));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

