/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument.infusion;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;

public abstract class AbstractInfusionRecipeBuilder {
    protected final Ingredient ingredient;
    protected int elementAmount;
    protected final IRecipeSerializer<?> serializer;

    protected AbstractInfusionRecipeBuilder(IRecipeSerializer<?> serializerIn, Ingredient ingredientIn) {
        this.serializer = serializerIn;
        this.ingredient = ingredientIn;
        this.elementAmount = 1000;
    }

    public AbstractInfusionRecipeBuilder withElementAmount(int elementAmount) {
        this.elementAmount = elementAmount;
        return this;
    }

    protected abstract ResourceLocation getId();

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation id = this.getId();
        this.build(consumerIn, new ResourceLocation(id.func_110624_b(), "infusion/" + id.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = this.getId();
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Infusion Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ElementalCraft.createRL("infusion/" + save));
    }

    public abstract void build(Consumer<IFinishedRecipe> var1, ResourceLocation var2);

    public static abstract class AbstractResult
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final int elementAmount;
        private final IRecipeSerializer<?> serializer;

        protected AbstractResult(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, int elementAmount) {
            this.id = idIn;
            this.serializer = serializerIn;
            this.ingredient = ingredientIn;
            this.elementAmount = elementAmount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("element_amount", (Number)this.elementAmount);
            json.add("input", this.ingredient.func_200304_c());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

