/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.datagen.recipe.builder.instrument.infusion;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.datagen.recipe.builder.instrument.infusion.AbstractInfusionRecipeBuilder;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;

public class ToolInfusionRecipeBuilder
extends AbstractInfusionRecipeBuilder {
    private final ResourceLocation infusion;
    private final String prefix;

    public ToolInfusionRecipeBuilder(IRecipeSerializer<?> serializerIn, ITag.INamedTag<Item> ingredientIn, ResourceLocation infusion) {
        super(serializerIn, Ingredient.func_199805_a(ingredientIn));
        String[] split = ingredientIn.func_230234_a_().func_110623_a().split("/");
        this.prefix = "tool/" + split[split.length - 1] + "_";
        this.infusion = infusion;
        this.elementAmount = 2000;
    }

    public static ToolInfusionRecipeBuilder toolInfusionRecipe(ITag.INamedTag<Item> ingredientIn, ResourceLocation infusion) {
        return new ToolInfusionRecipeBuilder(ToolInfusionRecipe.SERIALIZER, ingredientIn, infusion);
    }

    public static ToolInfusionRecipeBuilder toolInfusionRecipe(ITag.INamedTag<Item> ingredientIn, Enchantment enchantment) {
        return new ToolInfusionRecipeBuilder(ToolInfusionRecipe.SERIALIZER, ingredientIn, ElementalCraft.createRL(enchantment.getRegistryName().func_110623_a()));
    }

    @Override
    protected ResourceLocation getId() {
        String namespace = this.infusion.func_110624_b();
        return new ResourceLocation(namespace.equals("minecraft") ? "elementalcraft" : namespace, this.prefix + this.infusion.func_110623_a());
    }

    @Override
    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.serializer, this.ingredient, this.infusion, this.elementAmount));
    }

    public static class Result
    extends AbstractInfusionRecipeBuilder.AbstractResult {
        private final ResourceLocation infusion;

        public Result(ResourceLocation idIn, IRecipeSerializer<?> serializerIn, Ingredient ingredientIn, ResourceLocation infusion, int elementAmount) {
            super(idIn, serializerIn, ingredientIn, elementAmount);
            this.infusion = infusion;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.addProperty("tool_infusion", this.infusion.toString());
            super.func_218610_a(json);
        }
    }
}

