/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.player.PlayerElementStorage;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.item.ECItems;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class EntityHandler {
    private EntityHandler() {
    }

    @SubscribeEvent
    public static void onEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        int fastDraw = ToolInfusionHelper.getFasterDraw(event.getItem());
        if (fastDraw >= 0 && event.getDuration() % fastDraw == 0) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onEntityLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && world.func_201674_k().nextDouble() >= ToolInfusionHelper.getDodge(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT tag;
        PlayerEntity player = event.getPlayer();
        if (Boolean.TRUE.equals(ECConfig.COMMON.playersSpawnWithBook.get()) && !event.getEntityLiving().func_130014_f_().field_72995_K && !(tag = player.getPersistentData().func_74775_l("PlayerPersisted")).func_74767_n("has_elementopedia")) {
            ItemStack book = new ItemStack((IItemProvider)ECItems.ELEMENTOPEDIA);
            book.func_196082_o().func_74778_a("patchouli:book", "elementalcraft:element_book");
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)book);
            tag.func_74757_a("has_elementopedia", true);
            player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(ElementalCraft.createRL("element_storage"), PlayerElementStorage.createProvider((PlayerEntity)entity));
        }
    }
}

