/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.player;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public class PlayerElementStorage
implements IElementStorage {
    private final PlayerEntity player;

    private PlayerElementStorage(PlayerEntity player) {
        this.player = player;
    }

    @Nullable
    public static ICapabilityProvider createProvider(final PlayerEntity player) {
        return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY != null ? new ICapabilityProvider(){
            PlayerElementStorage storage;
            {
                this.storage = new PlayerElementStorage(player);
            }

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.storage));
            }
        } : null;
    }

    @Override
    public int getElementAmount(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementAmount(type)).sum();
    }

    @Override
    public int getElementCapacity(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementCapacity(type)).sum();
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        AtomicInteger remaining = new AtomicInteger(count);
        this.getStorages().forEach(storage -> remaining.set(storage.insertElement(remaining.get(), type, simulate)));
        return remaining.get();
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        AtomicInteger extracted = new AtomicInteger(0);
        this.getStorages().forEach(storage -> {
            int e = extracted.get();
            extracted.set(e + storage.extractElement(count - e, type, simulate));
        });
        return extracted.get();
    }

    @Override
    public boolean usableInInventory() {
        return true;
    }

    private List<IElementStorage> getStorages() {
        ArrayList storages = Lists.newArrayList();
        for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            CapabilityElementStorage.get((ICapabilityProvider)this.player.field_71071_by.func_70301_a(i)).filter(IElementStorage::usableInInventory).ifPresent(storages::add);
        }
        return storages;
    }
}

