/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.infusion.tool.effect.IToolInfusionEffect;

public class ToolInfusion
implements IElementTypeProvider {
    public static final String NAME = "tool_infusions";
    public static final String FOLDER = "elementalcraft_tool_infusions";
    public static final ToolInfusion NONE = new ToolInfusion(ElementType.NONE, Collections.emptyList());
    public static final Codec<ToolInfusion> CODEC = RecordCodecBuilder.create(builder -> builder.group(ElementType.forGetter(ToolInfusion::getElementType), (App)IToolInfusionEffect.CODEC.listOf().fieldOf("effects").forGetter(ToolInfusion::getEffects)).apply((Applicative)builder, ToolInfusion::new));
    private ResourceLocation id;
    private final ElementType elementType;
    private final List<IToolInfusionEffect> effects;

    public ToolInfusion(ElementType elementType, List<IToolInfusionEffect> effects) {
        this.elementType = elementType;
        this.effects = effects;
    }

    protected static <T extends ToolInfusion> Products.P1<RecordCodecBuilder.Mu<T>, ElementType> codec(RecordCodecBuilder.Instance<T> builder) {
        return builder.group(ElementType.forGetter(ToolInfusion::getElementType));
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipInformation() {
        ArrayList tooltip = Lists.newArrayList();
        if (this.effects.size() == 1) {
            tooltip.add(new TranslationTextComponent("tooltip.elementalcraft.infused.single", new Object[]{this.elementType.getDisplayName(), this.effects.get(0).getDescription()}).func_240699_a_(TextFormatting.YELLOW));
        } else {
            tooltip.add(new TranslationTextComponent("tooltip.elementalcraft.infused", new Object[]{this.elementType.getDisplayName()}).func_240699_a_(TextFormatting.YELLOW));
            this.effects.stream().map(e -> new StringTextComponent("").func_230529_a_(e.getDescription()).func_240699_a_(TextFormatting.YELLOW)).forEach(tooltip::add);
        }
        return tooltip;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public List<IToolInfusionEffect> getEffects() {
        return this.effects;
    }
}

