/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.effect.AttributeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.AutoSmeltToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.DodgeToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.ElementCostReductionToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.EnchantmentToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.FastDrawToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.IToolInfusionEffect;
import sirttas.elementalcraft.nbt.NBTHelper;

public class ToolInfusionHelper {
    private ToolInfusionHelper() {
    }

    public static ToolInfusion getInfusion(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getECTag(stack);
        if (nbt != null) {
            if (nbt.func_150297_b("infusion", 8)) {
                return (ToolInfusion)ElementalCraft.TOOL_INFUSION_MANAGER.get(new ResourceLocation(nbt.func_74779_i("infusion")));
            }
            if (nbt.func_150297_b("infusion", 10)) {
                nbt.func_82580_o("infusion");
            }
        }
        return null;
    }

    public static void setInfusion(ItemStack stack, ToolInfusion infusion) {
        CompoundNBT nbt = NBTHelper.getOrCreateECTag(stack);
        nbt.func_74778_a("infusion", infusion.getId().toString());
    }

    public static void removeInfusion(ItemStack stack) {
        CompoundNBT nbt = NBTHelper.getECTag(stack);
        if (!stack.func_190926_b() && nbt != null && nbt.func_74764_b("infusion")) {
            nbt.func_82580_o("infusion");
        }
    }

    public static boolean hasAutoSmelt(ItemStack stack) {
        return ToolInfusionHelper.getInfusionEffects(stack, AutoSmeltToolInfusionEffect.class).count() > 0L;
    }

    public static int getFasterDraw(ItemStack stack) {
        return ToolInfusionHelper.getInfusionEffects(stack, FastDrawToolInfusionEffect.class).findAny().map(FastDrawToolInfusionEffect::getValue).orElse(-1);
    }

    public static boolean hasFireInfusion(LivingEntity entity) {
        return ToolInfusionHelper.getInfusions(entity).anyMatch(infusion -> infusion.getElementType() == ElementType.FIRE);
    }

    public static double getDodge(LivingEntity entity) {
        return ToolInfusionHelper.getInfusionEffects(entity).filter(DodgeToolInfusionEffect.class::isInstance).map(DodgeToolInfusionEffect.class::cast).mapToDouble(infusion -> 1.0 - infusion.getValue()).reduce(1.0, (a, b) -> a * b);
    }

    private static Stream<ToolInfusion> getInfusions(LivingEntity entity) {
        return StreamSupport.stream(entity.func_184209_aF().spliterator(), false).map(ToolInfusionHelper::getInfusion).filter(Objects::nonNull);
    }

    private static Stream<IToolInfusionEffect> getInfusionEffects(LivingEntity entity) {
        return ToolInfusionHelper.getInfusions(entity).flatMap(t -> t.getEffects().stream());
    }

    private static <T extends IToolInfusionEffect> Stream<T> getInfusionEffects(ItemStack stack, Class<T> type) {
        ToolInfusion infusion = ToolInfusionHelper.getInfusion(stack);
        return infusion != null ? infusion.getEffects().stream().filter(type::isInstance).map(type::cast) : Stream.empty();
    }

    public static int getInfusionEnchantmentLevel(ItemStack stack, Enchantment ench) {
        return ToolInfusionHelper.getInfusionEffects(stack, EnchantmentToolInfusionEffect.class).filter(i -> i.getEnchantment() == ench).mapToInt(EnchantmentToolInfusionEffect::getLevel).sum();
    }

    public static Multimap<Attribute, AttributeModifier> getInfusionAttribute(ItemStack stack, EquipmentSlotType slot) {
        ArrayListMultimap map = ArrayListMultimap.create();
        ToolInfusionHelper.getInfusionEffects(stack, AttributeToolInfusionEffect.class).filter(i -> i.getSlots().contains(slot)).forEach(arg_0 -> ToolInfusionHelper.lambda$getInfusionAttribute$6((Multimap)map, arg_0));
        return map;
    }

    public static float getElementCostReduction(LivingEntity entity) {
        return (float)ToolInfusionHelper.getInfusionEffects(entity).filter(ElementCostReductionToolInfusionEffect.class::isInstance).map(ElementCostReductionToolInfusionEffect.class::cast).mapToDouble(infusion -> 1.0 - (double)infusion.getValue()).reduce(1.0, (a, b) -> a * b);
    }

    private static /* synthetic */ void lambda$getInfusionAttribute$6(Multimap map, AttributeToolInfusionEffect i) {
        map.put((Object)i.getAttribute(), (Object)i.getModifier());
    }
}

