/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool.effect;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.elementalcraft.infusion.tool.effect.IToolInfusionEffect;
import sirttas.elementalcraft.infusion.tool.effect.ToolInfusionEffectType;
import sirttas.elementalcraft.item.ItemEC;

public class AttributeToolInfusionEffect
implements IToolInfusionEffect {
    public static final String NAME = "attribute";
    public static final Codec<AttributeToolInfusionEffect> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.EQUIPMENT_SLOT_TYPE.listOf().fieldOf("slot").forGetter(i -> i.slots), (App)Codecs.ATTRIBUTE.fieldOf(NAME).forGetter(i -> i.attribute), (App)Codecs.ATTRIBUTE_MODIFIER.fieldOf("modifier").forGetter(i -> i.modifier)).apply((Applicative)builder, AttributeToolInfusionEffect::new));
    @ObjectHolder(value="elementalcraft:attribute")
    public static final ToolInfusionEffectType<AttributeToolInfusionEffect> TYPE = null;
    private final List<EquipmentSlotType> slots;
    private final Attribute attribute;
    private final AttributeModifier modifier;

    public AttributeToolInfusionEffect(List<EquipmentSlotType> slots, Attribute attribute, AttributeModifier modifier) {
        this.slots = ImmutableList.copyOf(slots);
        this.attribute = attribute;
        this.modifier = modifier;
    }

    @Override
    public ITextComponent getDescription() {
        return ItemEC.getAttributeTooltip(this.attribute, this.modifier).func_240699_a_(TextFormatting.YELLOW);
    }

    @Override
    public ToolInfusionEffectType<? extends IToolInfusionEffect> getType() {
        return TYPE;
    }

    public AttributeModifier getModifier() {
        return this.modifier;
    }

    public List<EquipmentSlotType> getSlots() {
        return this.slots;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }
}

