/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.EvaporationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ImprovedExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.SolarSynthesisRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.BindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.CrystallizationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.InscriptionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.GrindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.InfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.PurificationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ElementalCraft.createRL("main");
    private static final ISubtypeInterpreter HOLDER_INTERPRETER = stack -> CapabilityElementStorage.get((ICapabilityProvider)stack).map(storage -> {
        StringBuilder stringBuilder = new StringBuilder();
        ElementType.allValid().forEach(type -> {
            int amount = storage.getElementAmount((ElementType)type);
            if (amount > 0) {
                stringBuilder.append(type.func_176610_l());
                stringBuilder.append(':');
                stringBuilder.append(amount);
                stringBuilder.append(':');
                stringBuilder.append(storage.getElementCapacity((ElementType)type));
                stringBuilder.append(';');
            }
        });
        return stringBuilder.length() > 0 ? stringBuilder.toString() : "";
    }).orElse("");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ECIngredientTypes.ELEMENT, IngredientElementType.all(), (IIngredientHelper)new ElementIngredientHelper(), (IIngredientRenderer)new ElementIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.useNbtForSubtypes(new Item[]{ECItems.SCROLL});
        registry.useNbtForSubtypes(new Item[]{ECItems.RECEPTACLE, ECItems.RECEPTACLE_IMPROVED});
        registry.useNbtForSubtypes(new Item[]{ECItems.PURE_ORE});
        registry.useNbtForSubtypes(new Item[]{ECItems.RUNE});
        registry.useNbtForSubtypes(new Item[]{ECItems.TANK, ECItems.TANK_SMALL, ECItems.TANK_CREATIVE});
        registry.useNbtForSubtypes(new Item[]{ECItems.FIRE_RESERVOIR, ECItems.WATER_RESERVOIR, ECItems.EARTH_RESERVOIR, ECItems.AIR_RESERVOIR});
        registry.registerSubtypeInterpreter((Item)ECItems.FIRE_HOLDER, HOLDER_INTERPRETER);
        registry.registerSubtypeInterpreter((Item)ECItems.WATER_HOLDER, HOLDER_INTERPRETER);
        registry.registerSubtypeInterpreter((Item)ECItems.EARTH_HOLDER, HOLDER_INTERPRETER);
        registry.registerSubtypeInterpreter((Item)ECItems.AIR_HOLDER, HOLDER_INTERPRETER);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ImprovedExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolarSynthesisRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystallizationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriptionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GrindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.FIRE_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.FIRE_BLAST_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.EXTRACTOR), new ResourceLocation[]{ExtractionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.EXTRACTOR_IMPROVED), new ResourceLocation[]{ImprovedExtractionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.EVAPORATOR), new ResourceLocation[]{EvaporationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.SOLAR_SYNTHESIZER), new ResourceLocation[]{SolarSynthesisRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.INFUSER), new ResourceLocation[]{InfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.BINDER_IMPROVED), new ResourceLocation[]{InfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.BINDER), new ResourceLocation[]{BindingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.BINDER_IMPROVED), new ResourceLocation[]{BindingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.CRYSTALLIZER), new ResourceLocation[]{CrystallizationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.INSCRIBER), new ResourceLocation[]{InscriptionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.CHISEL), new ResourceLocation[]{InscriptionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.PURE_INFUSER), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.FIRE_PEDESTAL), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.WATER_PEDESTAL), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.EARTH_PEDESTAL), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.AIR_PEDESTAL), new ResourceLocation[]{PureInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.PURIFIER), new ResourceLocation[]{PurificationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.AIR_MILL), new ResourceLocation[]{GrindingRecipeCategory.UID});
        if (ECinteractions.isMekanismActive()) {
            registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ECItems.AIR_MILL), new ResourceLocation[]{new ResourceLocation("mekanism", "crusher")});
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registry.addRecipes(ElementType.allValid(), ExtractionRecipeCategory.UID);
        registry.addRecipes(ElementType.allValid(), ImprovedExtractionRecipeCategory.UID);
        registry.addRecipes(EvaporationRecipeCategory.getShards(), EvaporationRecipeCategory.UID);
        registry.addRecipes(SolarSynthesisRecipeCategory.getLenses(), SolarSynthesisRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(IInfusionRecipe.TYPE).values(), InfusionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(AbstractBindingRecipe.TYPE).values(), BindingRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(CrystallizationRecipe.TYPE).values(), CrystallizationRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(InscriptionRecipe.TYPE).values(), InscriptionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(PureInfusionRecipe.TYPE).values(), PureInfusionRecipeCategory.UID);
        registry.addRecipes(recipeManager.func_215366_a(IGrindingRecipe.TYPE).values(), GrindingRecipeCategory.UID);
        registry.addRecipes(ElementalCraft.PURE_ORE_MANAGER.getRecipes(), PurificationRecipeCategory.UID);
        registry.addRecipes(this.createFocusAnvilRecipes(registry.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
    }

    private List<?> createFocusAnvilRecipes(IVanillaRecipeFactory factory) {
        return Spell.REGISTRY.getValues().stream().filter(Spell::isValid).map(spell -> {
            ItemStack scroll = new ItemStack((IItemProvider)ECItems.SCROLL);
            ItemStack focus = new ItemStack((IItemProvider)ECItems.FOCUS);
            SpellHelper.setSpell(scroll, spell);
            SpellHelper.addSpell(focus, spell);
            return factory.createAnvilRecipe(new ItemStack((IItemProvider)ECItems.FOCUS), (List)ImmutableList.of((Object)scroll), (List)ImmutableList.of((Object)focus));
        }).collect(Collectors.toList());
    }
}

