/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument.io;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.AbstractIOInstrumentRecipeCategory;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;

public class InfusionRecipeCategory
extends AbstractIOInstrumentRecipeCategory<IInfuser, IInfusionRecipe> {
    public static final ResourceLocation UID = ElementalCraft.createRL("infusion");

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, new ItemStack((IItemProvider)ECItems.INFUSER));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends IInfusionRecipe> getRecipeClass() {
        return IInfusionRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"elementalcraft.jei.infusion", (Object[])new Object[0]);
    }

    @Override
    protected List<ItemStack> getTanks() {
        return ImmutableList.of((Object)this.tank, (Object)new ItemStack((IItemProvider)ECItems.TANK_SMALL));
    }

    @Override
    public void setIngredients(IInfusionRecipe recipe, IIngredients ingredients) {
        super.setIngredients(recipe, ingredients);
        if (recipe instanceof ToolInfusionRecipe) {
            ToolInfusion infusion = ((ToolInfusionRecipe)recipe).getToolInfusion();
            ingredients.setOutputLists(VanillaTypes.ITEM, recipe.func_192400_c().stream().map(i -> Arrays.stream(i.func_193365_a()).map(stack -> {
                ItemStack copy = stack.func_77946_l();
                ToolInfusionHelper.setInfusion(copy, infusion);
                return copy;
            }).collect(Collectors.toList())).collect(Collectors.toList()));
        }
    }
}

