/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.elemental;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.tile.TileEntityHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.elemental.ItemElemental;
import sirttas.elementalcraft.property.ECProperties;

public class ItemElementHolder
extends ItemElemental
implements ISourceInteractable {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private static final String SAVED_POS = "saved_pos";
    private final int elementCapacity;

    public ItemElementHolder(ElementType elementType) {
        super(ECProperties.Items.ITEM_UNSTACKABLE, elementType);
        this.elementCapacity = (Integer)ECConfig.COMMON.elementHolderCapacity.get();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        ElementStorage storage = new ElementStorage(stack);
        if (nbt != null && nbt.func_74764_b("Parent")) {
            storage.readNBT(nbt.func_74775_l("Parent"));
        }
        return SingleElementStorage.createProvider(storage);
    }

    public ISingleElementStorage getElementStorage(ItemStack stack) {
        return (ISingleElementStorage)CapabilityElementStorage.get((ICapabilityProvider)stack).orElse((Object)new StaticElementStorage(this.elementType, 0));
    }

    public int func_77626_a(ItemStack stack) {
        return this.elementCapacity / (Integer)ECConfig.COMMON.elementHolderTransferAmount.get();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    protected boolean isValidSource(BlockState state) {
        return state.func_177230_c().equals((Object)ECBlocks.SOURCE) && ElementType.getElementType(state) == this.elementType;
    }

    @Override
    public boolean canIteractWithSource(ItemStack stack, BlockState state) {
        return this.isValidSource(state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        ActionResultType result = this.tick(world, (LivingEntity)player, pos, stack);
        if (result.func_226246_a_()) {
            this.setSavedPos(stack, pos);
            player.func_184598_c(context.func_221531_n());
        }
        return result;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        BlockPos pos = this.getSavedPos(stack);
        double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        if (player.func_233580_cy_().func_177951_i((Vector3i)pos) + 1.0 > reach * reach || !this.tick(player.func_130014_f_(), player, pos, stack).func_226246_a_()) {
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.removeSavedPos(stack);
    }

    private ActionResultType tick(World world, LivingEntity entity, BlockPos pos, ItemStack stack) {
        BlockState blockstate = world.func_180495_p(pos);
        return TileEntityHelper.getElementStorageAt((IWorldReader)world, pos).map(storage -> {
            ISingleElementStorage holder = this.getElementStorage(stack);
            boolean isSource = this.isValidSource(blockstate);
            if (isSource || entity.func_225608_bj_()) {
                if (isSource || storage.canPipeExtract(this.elementType)) {
                    return storage.transferTo(holder, this.elementType, (Integer)ECConfig.COMMON.elementHolderTransferAmount.get()) > 0 ? ActionResultType.CONSUME : ActionResultType.PASS;
                }
            } else if (storage.canPipeInsert(this.elementType)) {
                return holder.transferTo((IElementStorage)storage, (Integer)ECConfig.COMMON.elementHolderTransferAmount.get()) > 0 ? ActionResultType.CONSUME : ActionResultType.PASS;
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.percent_full", new Object[]{ItemStack.field_111284_a.format(this.getElementStorage(stack).getElementAmount() * 100 / this.elementCapacity)}).func_240699_a_(TextFormatting.GREEN));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            ISingleElementStorage storage = this.getElementStorage(full);
            storage.insertElement(this.elementCapacity, false);
            items.add((Object)new ItemStack((IItemProvider)this));
            items.add((Object)full);
        }
    }

    public int getDamage(ItemStack stack) {
        return 1000 * (this.elementCapacity - this.getElementStorage(stack).getElementAmount()) / this.elementCapacity;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public BlockPos getSavedPos(ItemStack stack) {
        CompoundNBT savedPos;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (savedPos = tag.func_74775_l(SAVED_POS)) != null) {
            return NBTUtil.func_186861_c((CompoundNBT)savedPos);
        }
        return null;
    }

    public void setSavedPos(ItemStack stack, BlockPos pos) {
        stack.func_196082_o().func_218657_a(SAVED_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public void removeSavedPos(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(SAVED_POS);
        }
    }

    private class ElementStorage
    extends StaticElementStorage {
        private final ItemStack stack;

        public ElementStorage(ItemStack stack) {
            super(ItemElementHolder.this.elementType, ItemElementHolder.this.elementCapacity);
            this.stack = stack;
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount() {
            this.refresh();
            return super.getElementAmount();
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.insertElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.extractElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        private void refresh() {
            CompoundNBT tag = this.stack.func_77978_p();
            if (tag != null && tag.func_74764_b("element_amount")) {
                this.elementAmount = tag.func_74762_e("element_amount");
            }
        }

        private void updateAmount() {
            this.stack.func_196082_o().func_74768_a("element_amount", this.elementAmount);
        }
    }
}

