/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pureore.injector;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.item.pureore.injector.PureOreCookingRecipeInjector;
import sirttas.elementalcraft.registry.RegistryHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PureOreRecipeInjectors {
    private PureOreRecipeInjectors() {
    }

    @SubscribeEvent
    public static void registerPureOreRecipeInjectors(RegistryEvent.Register<AbstractPureOreRecipeInjector<?, ? extends IRecipe<?>>> event) {
        IForgeRegistry registry = event.getRegistry();
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreSmeltingRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<FurnaceRecipe>(IRecipeType.field_222150_b, FurnaceRecipe::new));
        }
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreBlastingRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<BlastingRecipe>(IRecipeType.field_222151_c, BlastingRecipe::new));
        }
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreCampFireRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<CampfireCookingRecipe>(IRecipeType.field_222153_e, CampfireCookingRecipe::new));
        }
        if (ECinteractions.isMekanismActive()) {
            MekanismInteraction.registerPureOreRecipeInjectors(registry);
        }
    }

    public static <C extends IInventory, T extends IRecipe<C>> void register(IForgeRegistry<AbstractPureOreRecipeInjector<?, ? extends IRecipe<?>>> registry, AbstractPureOreRecipeInjector<C, T> injector) {
        ResourceLocation id = injector.getRecipeTypeRegistryName();
        if (id == null) {
            throw new PureOreException("Cannot register injector as its RecipeType is absant in registry.");
        }
        RegistryHelper.register(registry, injector, ElementalCraft.createRL(id.func_110624_b() + '_' + id.func_110623_a()));
    }
}

