/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.SpellTickManager;

public abstract class AbstractItemSpellHolder
extends ItemEC
implements ISpellHolder {
    protected AbstractItemSpellHolder(Item.Properties properties) {
        super(properties);
    }

    protected void addAttributeTooltip(List<ITextComponent> tooltip, Spell spell) {
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.consumes", new Object[]{spell.getElementType().getDisplayName()}).func_240699_a_(TextFormatting.YELLOW));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.cooldown", new Object[]{spell.getCooldown() / 20}).func_240699_a_(TextFormatting.YELLOW));
        spell.addInformation(tooltip);
        AbstractItemSpellHolder.addAttributeMultimapToTooltip(tooltip, spell.getOnUseAttributeModifiers(), (ITextComponent)new TranslationTextComponent("tooltip.elementalcraft.on_spell_use").func_240699_a_(TextFormatting.GRAY));
    }

    public int func_77626_a(ItemStack stack) {
        return SpellHelper.getSpell(stack).getUseDuration();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return new ActionResult(this.tick(worldIn, playerIn, handIn, stack, true), (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (!(entity instanceof PlayerEntity) || this.tick(entity.func_130014_f_(), (PlayerEntity)entity, entity.func_184600_cs(), stack, false) != ActionResultType.CONSUME) {
            entity.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.func_77654_b(stack, worldIn, entityLiving);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        SpellTickManager.getInstance(worldIn).setCooldown((Entity)entityLiving, SpellHelper.getSpell(stack));
        return stack;
    }

    private ActionResultType tick(World worldIn, PlayerEntity playerIn, Hand handIn, ItemStack stack, boolean doChannel) {
        Spell spell = SpellHelper.getSpell(stack);
        Multimap<Attribute, AttributeModifier> attributes = spell.getOnUseAttributeModifiers();
        playerIn.func_233645_dx_().func_233793_b_(attributes);
        ActionResultType result = this.castSpell(playerIn, spell);
        if (result.func_226246_a_()) {
            if (this.doConsume(playerIn, handIn, stack, spell)) {
                result = ActionResultType.SUCCESS;
            }
            if (result.func_226247_b_() && !playerIn.func_184812_l_()) {
                SpellTickManager.getInstance(worldIn).setCooldown((Entity)playerIn, spell);
                playerIn.func_184597_cx();
            } else if (doChannel && spell.isChannelable()) {
                playerIn.func_184598_c(handIn);
            }
        } else {
            playerIn.func_184597_cx();
        }
        playerIn.func_233645_dx_().func_233785_a_(attributes);
        return result;
    }

    private ActionResultType castSpell(PlayerEntity player, Spell spell) {
        ActionResultType result = ActionResultType.PASS;
        RayTraceResult ray = EntityHelper.rayTrace((Entity)player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e());
        if (SpellTickManager.getInstance(player.field_70170_p).hasCooldown((Entity)player, spell)) {
            return result;
        }
        if (ray.func_216346_c() == RayTraceResult.Type.ENTITY) {
            result = spell.castOnEntity((Entity)player, ((EntityRayTraceResult)ray).func_216348_a());
        }
        if (ray.func_216346_c() == RayTraceResult.Type.BLOCK && !result.func_226246_a_()) {
            result = spell.castOnBlock((Entity)player, ((BlockRayTraceResult)ray).func_216350_a());
        }
        if (!result.func_226246_a_()) {
            result = spell.castOnSelf((Entity)player);
        }
        return result;
    }

    private boolean doConsume(PlayerEntity playerIn, Hand handIn, ItemStack stack, Spell spell) {
        if (!playerIn.func_184812_l_() && !spell.consume((Entity)playerIn)) {
            this.consume(stack);
            playerIn.func_213334_d(handIn);
            return true;
        }
        return false;
    }

    protected abstract void consume(ItemStack var1);

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return SpellHelper.getSpell(stack).getAttributeModifiers(equipmentSlot);
    }
}

