/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ItemEC;
import sirttas.elementalcraft.item.spell.book.SpellBookContainer;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.spell.SpellHelper;

public class ItemSpellBook
extends ItemEC {
    public static final String NAME = "spell_book";

    public ItemSpellBook() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(this.open(world, player, stack), (Object)stack);
    }

    public ActionResultType open(World world, PlayerEntity player, ItemStack stack) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a((INamedContainerProvider)new ContainerProvider(stack));
        return ActionResultType.CONSUME;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        SpellHelper.forEachSpell(stack, (spell, count) -> {
            if (count == 1) {
                tooltip.add((ITextComponent)new StringTextComponent("").func_230529_a_(spell.getDisplayName()).func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(count + " ").func_230529_a_(spell.getDisplayName()).func_240699_a_(TextFormatting.GRAY));
            }
        });
    }

    public int getDamage(ItemStack stack) {
        return (Integer)ECConfig.COMMON.spellBookMaxSpell.get() - SpellHelper.getSpellCount(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ECConfig.COMMON.spellBookMaxSpell.get();
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private static class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity palyer) {
            return SpellBookContainer.create(id, inventory, this.stack);
        }

        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }
    }
}

