/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.container.ECContainers;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.book.SpellBookMessage;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class SpellBookContainer
extends Container {
    static final int ROW_COUNT = (Spell.REGISTRY.getEntries().size() + 9 - 1) / 9;
    static final int SLOT_COUNT = ROW_COUNT * 9;
    private ItemStack book;
    private final IInventory inventory;
    private final PlayerEntity player;

    public SpellBookContainer(int id, PlayerInventory player) {
        this(id, player, new ItemStack((IItemProvider)ECItems.SPELL_BOOK));
    }

    private SpellBookContainer(int id, PlayerInventory playerInventoryIn, ItemStack book) {
        super(ECContainers.SPELL_BOOK, id);
        this.book = book;
        this.inventory = new Inventory(SLOT_COUNT);
        this.player = playerInventoryIn.field_70458_d;
        this.addSlots(playerInventoryIn);
    }

    public static SpellBookContainer create(int id, PlayerInventory playerInventoryIn, ItemStack book) {
        return new SpellBookContainer(id, playerInventoryIn, book);
    }

    private void addSlots(PlayerInventory playerInventoryIn) {
        for (int i = 0; i < ROW_COUNT; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new ScrollSlot(this.inventory, j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
        this.addPlayerSlots(playerInventoryIn, (ROW_COUNT - 4) * 18);
        this.refresh();
    }

    private void addPlayerSlots(PlayerInventory playerInventoryIn, int yOffset) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 103 + i * 18 + yOffset));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, i, 8 + i * 18, 161 + yOffset));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public boolean func_94531_b(Slot slotIn) {
        return slotIn.field_75222_d > SLOT_COUNT;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack old = stack.func_77946_l();
            Spell spell = SpellHelper.getSpell(stack);
            if (stack.func_77973_b() == ECItems.SCROLL && spell.isValid()) {
                if (index < SLOT_COUNT) {
                    this.removeSpell(stack);
                    return ItemStack.field_190927_a;
                }
                if (this.canAddSpell(stack, spell)) {
                    this.addSpell(stack, spell);
                    return ItemStack.field_190927_a;
                }
                if (stack.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                return old;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        PlayerInventory playerinventory = player.field_71071_by;
        Slot slot2 = slot = slotId >= 0 ? (Slot)this.field_75151_b.get(slotId) : null;
        if (slot == null || slot.func_75211_c().func_77973_b() != ECItems.SPELL_BOOK) {
            if (slotId < 0 || slotId >= SLOT_COUNT || clickTypeIn == ClickType.THROW || clickTypeIn == ClickType.QUICK_MOVE || clickTypeIn == ClickType.PICKUP_ALL) {
                return super.func_184996_a(slotId, dragType, clickTypeIn, player);
            }
            if (clickTypeIn == ClickType.CLONE && player.func_184812_l_() && playerinventory.func_70445_o().func_190926_b()) {
                if (slot != null && slot.func_75216_d()) {
                    ItemStack scroll = slot.func_75211_c().func_77946_l();
                    scroll.func_190920_e(1);
                    playerinventory.func_70437_b(scroll);
                }
            } else if (clickTypeIn == ClickType.PICKUP) {
                if (playerinventory.func_70445_o().func_190926_b()) {
                    if (slot != null && slot.func_75216_d()) {
                        ItemStack stack = slot.func_75211_c();
                        ItemStack scroll = stack.func_77946_l();
                        stack.func_190918_g(1);
                        scroll.func_190920_e(1);
                        SpellHelper.removeSpell(this.book, SpellHelper.getSpell(stack));
                        playerinventory.func_70437_b(scroll);
                        this.refresh();
                        return scroll;
                    }
                } else {
                    ItemStack stack = playerinventory.func_70445_o();
                    Spell spell = SpellHelper.getSpell(stack);
                    if (stack.func_77973_b() == ECItems.SCROLL && spell.isValid()) {
                        SpellHelper.addSpell(this.book, spell);
                        playerinventory.func_70437_b(ItemStack.field_190927_a);
                        this.refresh();
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public int getSpellCount() {
        int spellCount = SpellHelper.getSpellCount(this.book);
        return spellCount > 0 ? spellCount : IntStream.range(0, SLOT_COUNT).map(i -> {
            ItemStack stack = this.inventory.func_70301_a(i);
            return stack.func_190926_b() ? 0 : stack.func_190916_E();
        }).sum();
    }

    public void setBook(ItemStack book) {
        this.book = book;
        this.refresh();
    }

    public boolean canAddSpell(ItemStack stack, Spell spell) {
        return stack.func_77973_b() == ECItems.SCROLL && spell.isValid() && SpellHelper.getSpellCount(stack) < (Integer)ECConfig.COMMON.spellBookMaxSpell.get();
    }

    private void refresh() {
        List<Pair<Spell, Integer>> spells = SpellHelper.getSpellsAsMap(this.book);
        for (int i = 0; i < SLOT_COUNT; ++i) {
            if (i < spells.size()) {
                ItemStack scroll = new ItemStack((IItemProvider)ECItems.SCROLL);
                Pair<Spell, Integer> pair = spells.get(i);
                SpellHelper.setSpell(scroll, (Spell)pair.getFirst());
                scroll.func_190920_e(((Integer)pair.getSecond()).intValue());
                this.inventory.func_70299_a(i, scroll);
            } else {
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            this.field_75151_b.forEach(Slot::func_75218_e);
        }
        if (this.player instanceof ServerPlayerEntity) {
            MessageHelper.sendToPlayer((ServerPlayerEntity)this.player, new SpellBookMessage(this.book));
        }
    }

    private void removeSpell(ItemStack stack) {
        Spell spell = SpellHelper.getSpell(stack);
        if (spell.isValid()) {
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i + SLOT_COUNT);
                if (slot == null || slot.func_75216_d()) continue;
                ItemStack scroll = new ItemStack((IItemProvider)ECItems.SCROLL);
                SpellHelper.setSpell(scroll, spell);
                slot.func_75215_d(scroll);
                stack.func_190918_g(1);
                SpellHelper.removeSpell(this.book, spell);
                slot.func_75218_e();
                this.refresh();
                return;
            }
        }
    }

    private void addSpell(ItemStack stack, Spell spell) {
        for (int i = 0; i < SLOT_COUNT; ++i) {
            ItemStack stackInSlot;
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot == null || !(stackInSlot = slot.func_75211_c()).func_190926_b() && !spell.equals(SpellHelper.getSpell(stackInSlot))) continue;
            stack.func_190918_g(1);
            SpellHelper.addSpell(this.book, spell);
            this.refresh();
            return;
        }
    }

    private static class ScrollSlot
    extends Slot {
        public ScrollSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() == ECItems.SCROLL && this.func_75211_c().func_190926_b();
        }

        public int func_75219_a() {
            return (Integer)ECConfig.COMMON.spellBookMaxSpell.get();
        }
    }
}

