/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.network.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import sirttas.elementalcraft.block.instrument.mill.RendererAirMill;
import sirttas.elementalcraft.block.solarsynthesizer.RendererSolarSynthesizer;
import sirttas.elementalcraft.block.tile.renderer.ECRenderers;
import sirttas.elementalcraft.entity.ECEntities;
import sirttas.elementalcraft.inventory.container.screen.ECScreens;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.network.proxy.IProxy;
import sirttas.elementalcraft.particle.ECParticles;
import sirttas.elementalcraft.rune.Runes;
import sirttas.elementalcraft.spell.SpellTickManager;

public class ClientProxy
implements IProxy {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    @Override
    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupClient);
        modBus.addListener(ECItems::replaceModels);
        modBus.addListener(this::registerModels);
        modBus.addListener(this::stitchTextures);
        modBus.addListener(ECItems::registerItemColors);
        modBus.addListener(ECParticles::registerFactories);
        MinecraftForge.EVENT_BUS.addListener(SpellTickManager::clientTick);
    }

    @Override
    public World getDefaultWorld() {
        return this.minecraft.field_71441_e;
    }

    @Override
    public PlayerEntity getDefaultPlayer() {
        return this.minecraft.field_71439_g;
    }

    private void setupClient(FMLClientSetupEvent event) {
        ECRenderers.initRenderLayouts();
        ECEntities.registerRenderers();
        ECScreens.initScreenFactories();
    }

    public void registerModels(ModelRegistryEvent event) {
        Runes.registerModels();
        ModelLoader.addSpecialModel((ResourceLocation)RendererSolarSynthesizer.LENSE_LOCATION);
        ModelLoader.addSpecialModel((ResourceLocation)RendererAirMill.BLADES_LOCATION);
    }

    public void stitchTextures(TextureStitchEvent.Pre event) {
        this.addSprite(event, RendererSolarSynthesizer.BEAM);
    }

    private void addSprite(TextureStitchEvent.Pre event, RenderMaterial sprite) {
        if (event.getMap().func_229223_g_().equals((Object)sprite.func_229310_a_())) {
            event.addSprite(sprite.func_229313_b_());
        }
    }
}

