/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.inscriber.TileInscriber;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class InscriptionRecipe
extends AbstractInstrumentRecipe<TileInscriber> {
    public static final String NAME = "inscription";
    public static final IRecipeType<InscriptionRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("inscription"), (Object)new IRecipeType<InscriptionRecipe>(){

        public String toString() {
            return InscriptionRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:inscription")
    public static final IRecipeSerializer<InscriptionRecipe> SERIALIZER = null;
    private final NonNullList<Ingredient> ingredients;
    private final int elementAmount;
    private final ItemStack output;

    public InscriptionRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.stream().toArray(Ingredient[]::new));
        this.elementAmount = elementAmount;
        this.output = output;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(TileInscriber inv) {
        if (inv.getTankElementType() == this.getElementType()) {
            return RecipeHelper.matchesUnordered(inv.getInventory(), this.ingredients);
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @Override
    public void process(TileInscriber instrument) {
        instrument.func_174888_l();
        super.process(instrument);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InscriptionRecipe> {
        public InscriptionRecipe read(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ingredients.add(0, (Object)RecipeHelper.deserializeIngredient(json, "slate"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new InscriptionRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public InscriptionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_218666_n());
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new InscriptionRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void write(PacketBuffer buffer, InscriptionRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.writeInt(recipe.func_192400_c().size());
            recipe.func_192400_c().forEach(ingredient -> ingredient.func_199564_a(buffer));
        }
    }
}

