/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class ToolInfusionRecipe
implements IInfusionRecipe {
    public static final String NAME = "tool_infusion";
    @ObjectHolder(value="elementalcraft:tool_infusion")
    public static final IRecipeSerializer<ToolInfusionRecipe> SERIALIZER = null;
    private final Ingredient input;
    private final int elementAmount;
    private final Lazy<ToolInfusion> toolInfusion;
    protected final ResourceLocation id;

    public ToolInfusionRecipe(ResourceLocation id, ResourceLocation toolInfusion, Ingredient input, int elementAmount) {
        this.id = id;
        this.toolInfusion = ElementalCraft.TOOL_INFUSION_MANAGER.getLazy(toolInfusion);
        this.input = input;
        this.elementAmount = elementAmount;
    }

    @Override
    public boolean matches(IInfuser instrument) {
        return IInfusionRecipe.super.matches(instrument) && !this.getToolInfusion().equals(ToolInfusionHelper.getInfusion(instrument.getItem()));
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getCraftingResult(IInfuser instrument) {
        ItemStack stack = instrument.getItem();
        ToolInfusionHelper.setInfusion(stack, this.getToolInfusion());
        return stack;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public ElementType getElementType() {
        return this.getToolInfusion().getElementType();
    }

    public ToolInfusion getToolInfusion() {
        return (ToolInfusion)this.toolInfusion.get();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ToolInfusionRecipe> {
        public ToolInfusionRecipe read(ResourceLocation recipeId, JsonObject json) {
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            Ingredient input = RecipeHelper.deserializeIngredient(json, "input");
            ResourceLocation toolInfusion = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)ToolInfusionRecipe.NAME));
            return new ToolInfusionRecipe(recipeId, toolInfusion, input, elementAmount);
        }

        public ToolInfusionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int elementAmount = buffer.readInt();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ResourceLocation toolInfusion = buffer.func_192575_l();
            return new ToolInfusionRecipe(recipeId, toolInfusion, input, elementAmount);
        }

        public void write(PacketBuffer buffer, ToolInfusionRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            recipe.getInput().func_199564_a(buffer);
            buffer.func_192572_a(recipe.getToolInfusion().getId());
        }
    }
}

