/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.purifier.TilePurifier;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.instrument.io.IIOInstrumentRecipe;
import sirttas.elementalcraft.rune.Rune;

public class PurifierRecipe
implements IIOInstrumentRecipe<TilePurifier> {
    private final ResourceLocation id;
    private final ItemStack result;
    protected Ingredient input;

    public PurifierRecipe(ItemStack ore) {
        ResourceLocation oreName = ore.func_77973_b().getRegistryName();
        this.input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ore});
        this.id = ElementalCraft.createRL(oreName.func_110624_b() + '_' + oreName.func_110623_a() + "_to_pure_ore");
        this.result = ElementalCraft.PURE_ORE_MANAGER.createPureOre(ore.func_77973_b()).func_77946_l();
        this.result.func_190920_e(((Integer)ECConfig.COMMON.pureOreMultiplier.get()).intValue());
    }

    @Override
    public int getElementAmount() {
        return (Integer)ECConfig.COMMON.purifierBaseCost.get();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return ElementalCraft.PURE_ORE_MANAGER.isValidOre(stack) && this.input.test(stack);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public IRecipeType<?> func_222127_g() {
        return null;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.EARTH;
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public int getLuck(TilePurifier instrument) {
        return (int)Math.round((double)instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.purifierLuckRatio.get());
    }

    @Override
    public Random getRand(TilePurifier instrument) {
        return instrument.func_145831_w().func_201674_k();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }
}

